/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecorderCommandHandler.java,v 1.3 2005/04/22 20:18:45 jnevicos Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.recorder.remote;

import org.eclipse.hyades.execution.core.IControlMessage;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;


/**
 * Handles control commands from the Agent Controller by passing them to the appropriate RecorderAgentController method
 * @author Ernest Jessee
 */
public class RecorderCommandHandler implements CustomCommandHandler
{

	/**
	 * RecorderAgentController which instantiated the RecorderCommandHandler and registered it.
	 */
	private RecorderAgentController parent;
	
	
	/**
	 * constructor
	 */
	public RecorderCommandHandler(RecorderAgentController recorderController)
	{
		parent = recorderController;
	}
	
	/**
	 * @see org.eclipse.hyades.internal.execution.remote.CustomCommandHandler#handleCommand(org.eclipse.hyades.internal.execution.local.common.CustomCommand)
	 */
	public void handleCommand(CustomCommand command)
	{
		try
		{
			if(command.getData().equals(IControlMessage.START))
			{		
				 handleStartCommand();
			}		
			else if(command.getData().startsWith("StartRecording")) //$NON-NLS-1$
			{
				handleStartCommand();
				handleStartRecordingCommand();
			}
			else if(command.getData().startsWith("Init")) //$NON-NLS-1$
			{
				handleInitCommand(command);			
			}
			else if(command.getData().startsWith("Stop")) //$NON-NLS-1$
			{
				handleStopCommand(command);
			}
			else if (command.getData().startsWith("Annotate")) //$NON-NLS-1$
			{
				handleAnnotateCommand(command);
			}
			else
			{
				parent.sendDebugMessageToDataProcessor("un-interpreted command: "+command.getData()); //$NON-NLS-1$
			}
		}
		catch (Exception e)
		{
			parent.reportException("error processing command "+command.getData(),e); //$NON-NLS-1$
		}
	}
	
	
	
	private void handleStopCommand(CustomCommand command)
	{
		parent.stopRecording();	
		
	}
	
	
	private String stripFlag(CustomCommand command)
	{
		String initInfo = command.getData();
		initInfo = initInfo.substring(initInfo.indexOf(" "),initInfo.length()); //$NON-NLS-1$
		return initInfo.trim();
	}
		
	
	private void handleStartCommand()
	{
		parent.setOKToStart(true);
	}
	
	private void handleInitCommand(CustomCommand command)
	{
		parent.initAgent(stripFlag(command));				
			
	}
	
	
	private void handleStartRecordingCommand()
	{
		parent.startRecording();			
	}
	
	private void handleAnnotateCommand(CustomCommand command)
	{
		parent.annotateRecording(command.getData());
	}

}
