/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExecutionDeploymentAdapterExtended.java,v 1.4 2007/05/02 19:36:14 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.harness;

import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * @author Scott E. Schneider
 */
public interface IExecutionDeploymentAdapterExtended extends
        IExecutionDeploymentAdapter {
    /**
     * The implementation of this method should deploy test artifacts to their
     * corresponding locations. Test artifacts and locations are referenced in
     * the {@link org.eclipse.hyades.models.common.configuration.CFGArtifact}-
     * {@link org.eclipse.hyades.models.common.configuration.CFGLocation}pairs
     * contained in the specified
     * {@link org.eclipse.hyades.models.common.testprofile.TPFDeployment}.
     * 
     * @param node
     *            the node to where the test assets shall be deployed.
     * @param deployment
     *            {@link org.eclipse.hyades.models.common.testprofile.TPFDeployment}
     *            that contains the
     *            {@link org.eclipse.hyades.models.common.configuration.CFGArtifact}-
     *            {@link org.eclipse.hyades.models.common.configuration.CFGLocation}
     *            pairs to be deployed.
     * @param isStandalone
     *            if this is a standalone execution outside of eclipse.
     * @param bufError
     *            used to accumulate errors while deploying test assets
     */
    public void deployTestAssets(INode node, TPFDeployment deployment,
            boolean isStandalone, StringBuffer bufError);

    /**
     * This method provide the point to clean up any test artifacts that were
     * deployed after test execution is finished.
     * 
     * @param node
     *            the node to where the test assets shall be deployed.
     * @param deployment
     *            the same
     *            {@link org.eclipse.hyades.models.common.testprofile.TPFDeployment}
     *            that was used to set up the test artifacts.
     * @param isStandalone
     *            if this is a standalone execution outside of eclipse.
     * @param bufError
     *            used to accumulate errors while cleaning up test assets
     */
    public void cleanUpTestAssets(INode node, TPFDeployment deployment,
            boolean isStandalone, StringBuffer bufError);
}