/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExecutionHarnessDataProcessor.java,v 1.4 2005/10/11 21:14:06 sschneid Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness;

import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * @author Ernest Jessee
 */
public interface IExecutionHarnessDataProcessor extends DataProcessor
{
	/**
	 * @param proc
	 * @param agent
	 */
	public void init();	
	public String getName();
	public String getID();
	public ITest getTest();
	public void setControlAgent(Agent theAgent);
	public Agent getControlAgent();
	/**
	 * Initialize this data processor.
	 * @param theTest
	 * @param hostName
	 * @param executionResultName
	 * @param executionResultLocation
	 * @param portNumber
	 */
	//public void setInitData(ITest theTest,String hostName,String executionResultName, String executionResultLocation,String portNumber);
	public void setInitData(ITest theTest, String hostName, String executionResultName, String executionResultLocation, boolean overwriteExistinResults, String portNumber, TPFDeployment deployment);
	public void setProcess(Process process);
	public Process getProcess();
	
}
