/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExecutionHarnessDataProcessor2.java,v 1.2 2005/02/25 22:17:53 hleung Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness;

import org.eclipse.hyades.models.common.facades.behavioral.ITest;


/**
 * Extends {@link org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor}
 * to provide new method definitions.
 * 
 * @author bjiang
 */
public interface IExecutionHarnessDataProcessor2 extends IExecutionHarnessDataProcessor {
	/**
	 * Initialize this data processor.
	 * @param theTest
	 * @param hostName
	 * @param executionResultName
	 * @param overwriteExistinResults
	 * @param executionResultLocation
	 * @param portNumber
	 */
	public void setInitData(ITest theTest, String hostName, String executionResultName, String executionResultLocation, boolean overwriteExistinResults, String portNumber);
}
