/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JavaProcessExecutableObjectAdapter.java,v 1.7 2006/05/24 20:08:48 mddunn Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness;

import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.harness.util.ExecutionAdapterUtilities;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * @author rduggan
 * 
 * This is an adapter that knows how to configure the JavaProcessExecutorImpl at
 * runtime.
 */
public class JavaProcessExecutableObjectAdapter implements IExecutableObjectAdapter {

	// bugzilla 84790: runner system properties (passed to runner as named
	// parameters)
	protected final String TEST_CLASS = "hyades.runner.testClass"; //$NON-NLS-1$

	protected final String TEST_ID = "hyades.runner.testID"; //$NON-NLS-1$

	protected final String AGENT_NAME = "hyades.runner.agentName"; //$NON-NLS-1$

	protected final String TEST_METHOD = "hyades.runner.testMethod"; //$NON-NLS-1$

	// bugzilla 84790
	protected String jvmArgs = null;

	/**
	 * @see org.eclipse.hyades.execution.harness.IExecutableObjectAdapter#setupExecutableObject(org.eclipse.hyades.execution.core.IExecutableObject,
	 *      org.eclipse.hyades.models.common.testprofile.TPFTestSuite,
	 *      org.eclipse.hyades.models.common.testprofile.TPFTest)
	 */
	public void setupExecutableObject(IExecutableObject execObj, CFGClass rootResource, IImplementor theImplementor,
			TPFDeployment deployment) throws ClassCastException {
		/* Read the classname of the test out of the test suite */
		String testID = theImplementor.getId();
		String testClass = theImplementor.getResource();
		final boolean DEBUG = false;

		// Get the number of users from the CFGInstance
		int nusers = 1;
		try {
			if (rootResource instanceof TPFTestSuite) {
				if (((TPFTestSuite) rootResource).getInstances().isEmpty()) {
					CFGInstance instance = Common_ConfigurationFactory.eINSTANCE.createCFGInstance();
					((TPFTestSuite) rootResource).getInstances().add(instance);
				}

				CFGInstance cfg = (CFGInstance) ((TPFTestSuite) rootResource).getInstances().get(0);
				nusers = cfg.getMaxCount();
			}
		} catch (Exception e) {
			nusers = 1;
		}

		jvmArgs = ""; //$NON-NLS-1$

		if (DEBUG)
			jvmArgs += "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=8005 "; //$NON-NLS-1$

		jvmArgs += "-Dhyades.loadtest.nusers=" + nusers + " "; //$NON-NLS-1$ //$NON-NLS-2$

		// bugzilla 84790 fix, default is to used named parameters
		if (ExecutionAdapterUtilities.useNamedParameters()) {
			setJvmArgsNewMethod(rootResource, theImplementor, testClass, testID);
		} else {
			setJvmArgsOldMethod(rootResource, theImplementor, testClass, testID, nusers);
		}

		// Retrieve first location
		CFGPropertyGroup propGroup = ConfigurationUtil.searchPropertyGroupById(((CFGArtifactLocationPair) deployment
				.getArtifactLocations().get(0)).getLocation().getPropertyGroups(),
				ConfigurationUtil.ATTRS_PROP_GROUP_ID_LOCATION);

		// Retrieve used root directory setting
		BVRProperty[] props = ConfigurationUtil.searchPropertiesByName(propGroup.getProperties(),
				ConfigurationUtil.USED_ROOTDIR, false);

		// If the used root directory entry exists, set process location
		if (!(props == null || props.length == 0)) {
			((JavaProcessExecutableObjectStub) execObj).setLocation(props[0].getValue());
		}

		((JavaProcessExecutableObjectStub) execObj).setArgs(jvmArgs);
		((JavaProcessExecutableObjectStub) execObj).setTestID(testID);
		((JavaProcessExecutableObjectStub) execObj).setSuiteID(rootResource.getId());
	}

	// bugzilla 84790 fix, set command line args the new way (named parameters)
	protected void setJvmArgsNewMethod(CFGClass rootResource, IImplementor theImplementor, String testClass, String testID) {
		// If we're running something other than a test suite, pass in the name
		// of the
		// test method we should call
		if (!(rootResource instanceof ITestSuite)) {
			jvmArgs += "-D" + TEST_METHOD + "=" + theImplementor.getLocation() + " "; //$NON-NLS-1$ //$NON-NLS-2$ 
		}
		// the runner assumes, if testClass property is set, then named
		// parameters are being used
		jvmArgs += "-D" + TEST_CLASS + "=" + testClass + " "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		jvmArgs += "-D" + TEST_ID + "=" + testID + " "; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		jvmArgs += "org.eclipse.hyades.test.java.runner.HyadesJUnitRunner "; //$NON-NLS-1$
	}

	// bugzilla 84790 fix, set command line args the old way
	// args assumed by runner to be in a particular position
	private void setJvmArgsOldMethod(CFGClass rootResource, IImplementor theImplementor, String testClass, String testID,
			int nusers) {
		// use old positional arguments
		jvmArgs += "org.eclipse.hyades.test.java.runner.HyadesJUnitRunner " + testClass + " "; //$NON-NLS-1$ //$NON-NLS-2$
		jvmArgs += testID + " " + nusers; //$NON-NLS-1$

		// If we're running something other than a test suite, pass in the name
		// of the
		// test method we should call
		if (!(rootResource instanceof ITestSuite))
			jvmArgs += " " + theImplementor.getLocation(); //$NON-NLS-1$
	}
}
