/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionHarnessPluginResourceBundle.java,v 1.1 2007/03/22 20:38:51 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness.internal.resources;

import org.eclipse.osgi.util.NLS;

/**
 * Plug-in level resource bundle.
 * <p>
 * 
 * 
 * @author      Paul E. Slauenwhite
 * @version     March 22, 2007
 * @since       March 15, 2007
 */
public final class ExecutionHarnessPluginResourceBundle extends NLS {

	private static final String BUNDLE_NAME = "org.eclipse.hyades.execution.harness.internal.resources.messages";//$NON-NLS-1$

	private ExecutionHarnessPluginResourceBundle() {
		// Do not instantiate
	}

	public static String EXEC_NOT_FOUND_ERR_;
	public static String EXEC_ENV_ERR_;
	public static String FILE_DEPLOY_ERR_;
	public static String TEST_SUITE_JOB_NAME;
	public static String WAITING_TO_EXECUTE;
	public static String PREPARING_AND_DEPLOYING;
	public static String RUNNING_AND_COLLECTING_RESULTS;
	public static String EXECUTING_TESTS;
	public static String LOAD_SUITE_ERR_;
	public static String NULL_HOST_NAME_ERR;
	public static String CLASS_NOT_FOUND_ERR_;
	public static String TEST_ABORTED_MESSAGE_;
	public static String CANNOT_SUPPORT_MSG_;
	public static String NO_SESSION_FOUND_ERROR;
	public static String CANNOT_PERFORM_MSG_;
	public static String TIMEOUT_NODE_ERROR_;
	public static String AGENT_UNAV_ERROR_;
	public static String RUN_FAILED_ERR_;	
	public static String TEST_STOP_ERROR_;
	
	static {
		NLS.initializeMessages(BUNDLE_NAME, ExecutionHarnessPluginResourceBundle.class);
	}
}