/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ITestExecutionHarnessListener.java,v 1.1 2006/03/30 15:52:59 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.execution.harness.provisional;

import java.util.List;

import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * @author jtoomey
 *
 */
public interface ITestExecutionHarnessListener {
	
	public void launchStarted(IImplementor theImplementor, TPFDeployment 
			deployment, String port, String executionResultLocation,
			String executionResultName);
	public void sessionCreated(ISession session);
	public void testArtifactsDeployed();
	public void executionEnvironmentAdapted(IExecutionEnvironment env);
	public void executableObjectAdapted(IExecutableObject obj);
	public void dataProcessorsInitialized(List dataprocessors);
	public void launchCompleted(IExecutionHarnessDataProcessor 
			harnessProcessor);
	public void testCompleted();
	public void allModelsLoaded();
	
	public void dispose();

}
