/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: TestExecutionHarnessListenerNotifier.java,v 1.1 2006/03/30 15:52:57 jptoomey Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.execution.harness.provisional;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * @author jtoomey
 *
 */
public class TestExecutionHarnessListenerNotifier {

	public static void notifyLaunchStarted(IImplementor theImplementor, TPFDeployment 
			deployment, String port, String executionResultLocation,
			String executionResultName, List listeners) {
		if (listeners != null && !listeners.isEmpty()) {
			for (Iterator iter = listeners.iterator(); iter.hasNext();) {
				ITestExecutionHarnessListener listener = 
					(ITestExecutionHarnessListener) iter.next();
				listener.launchStarted(theImplementor, deployment, port, 
						executionResultLocation, executionResultName);
			}
		}
	}
	public static void notifySessionCreated(ISession session, List listeners) {
		if (listeners != null && !listeners.isEmpty()) {
			for (Iterator iter = listeners.iterator(); iter.hasNext();) {
				ITestExecutionHarnessListener listener = 
					(ITestExecutionHarnessListener) iter.next();
				listener.sessionCreated(session);
			}
		}
	}
	public static void notifyTestArtifactsDeployed(List listeners) {
		if (listeners != null && !listeners.isEmpty()) {
			for (Iterator iter = listeners.iterator(); iter.hasNext();) {
				ITestExecutionHarnessListener listener = 
					(ITestExecutionHarnessListener) iter.next();
				listener.testArtifactsDeployed();
			}
		}
	}
	public static void notifyExecutionEnvironmentAdapted(IExecutionEnvironment 
			env, List listeners) {
		if (listeners != null && !listeners.isEmpty()) {
			for (Iterator iter = listeners.iterator(); iter.hasNext();) {
				ITestExecutionHarnessListener listener = 
					(ITestExecutionHarnessListener) iter.next();
				listener.executionEnvironmentAdapted(env);
			}
		}
	}
	public static void notifyExecutableObjectAdapted(IExecutableObject obj, 
			List listeners) {
		if (listeners != null && !listeners.isEmpty()) {
			for (Iterator iter = listeners.iterator(); iter.hasNext();) {
				ITestExecutionHarnessListener listener = 
					(ITestExecutionHarnessListener) iter.next();
				listener.executableObjectAdapted(obj);
			}
		}
	}
	public static void notifyDataProcessorsInitialized(List dataprocessors, 
			List listeners) {
		if (listeners != null && !listeners.isEmpty()) {
			for (Iterator iter = listeners.iterator(); iter.hasNext();) {
				ITestExecutionHarnessListener listener = 
					(ITestExecutionHarnessListener) iter.next();
				listener.dataProcessorsInitialized(dataprocessors);
			}
		}
	}
	public static void notifyLaunchCompleted(IExecutionHarnessDataProcessor 
			harnessProcessor, List listeners) {
		if (listeners != null && !listeners.isEmpty()) {
			for (Iterator iter = listeners.iterator(); iter.hasNext();) {
				ITestExecutionHarnessListener listener = 
					(ITestExecutionHarnessListener) iter.next();
				listener.launchCompleted(harnessProcessor);
			}
		}
	}
	
	public static void notifyTestCompleted(List listeners) {
		// TODO: Not functional yet
		if (listeners != null && !listeners.isEmpty()) {
			for (Iterator iter = listeners.iterator(); iter.hasNext();) {
				ITestExecutionHarnessListener listener = 
					(ITestExecutionHarnessListener) iter.next();
				listener.testCompleted();
			}
		}
	}
	public static void notifyAllModelsLoaded(List listeners) {
		// TODO: Not functional yet
		if (listeners != null && !listeners.isEmpty()) {
			for (Iterator iter = listeners.iterator(); iter.hasNext();) {
				ITestExecutionHarnessListener listener = 
					(ITestExecutionHarnessListener) iter.next();
				listener.allModelsLoaded();
			}
		}
	}

}
