/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeploymentUtilities.java,v 1.4 2007/04/26 18:16:35 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness.util;

import java.util.Iterator;

import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * @author bjiang
 * @since  3.0
 * @deprecated use {@link org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil} instead.
 */
public class DeploymentUtilities {

	/**
	 * @param rootResource
	 * @param theImplementor
	 * @param deployment
	 * @return
	 * @deprecated use {@link org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil#getHostNameForTestAsset(CFGClass, IImplementor, TPFDeployment)} instead.
	 */
	public static String getTestMachine( CFGClass rootResource, IImplementor theImplementor, TPFDeployment deployment)
	{
		String machineName = null;
		if(!deployment.getArtifactLocations().isEmpty())
		{
			CFGArtifactLocationPair pair = searchPairWithTestAsset(rootResource, deployment);
			if(pair != null)
			{
				CFGLocation location = pair.getLocation();
				if(location instanceof CFGMachineConstraint)
					machineName = ((CFGMachineConstraint)location).getHostname();
				else if(location != null)
					machineName = location.getName();
			}
		}
		
		return machineName;
	}
	
	/**
	 * @param testAsset
	 * @param deployment
	 * @return
	 * @deprecated use {@link org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil#searchPairWithTestAsset(CFGClass, TPFDeployment)} instead.
	 */
	public static CFGArtifactLocationPair searchPairWithTestAsset(CFGClass testAsset, TPFDeployment deployment)
	{
		CFGArtifactLocationPair pair = null;
		CFGArtifact artifact = null;
		for(Iterator i = deployment.getArtifactLocations().iterator(); i.hasNext();)
		{
			pair = (CFGArtifactLocationPair)i.next();
			artifact = pair.getArtifact();
			if(artifact != null && !artifact.getDeployableInstances().isEmpty())
			{
				for(Iterator it = artifact.getDeployableInstances().iterator(); it.hasNext();)
				{
					CFGClass cls = (CFGClass)it.next();
					if(cls.getId() != null && cls.getId().equals(testAsset.getId()))
						return pair;
				}
			}
		}
		
		return null;
	}
}
