/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISystemUtility.java,v 1.8 2007/03/22 20:38:51 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness.util;

import java.util.ResourceBundle;

/**
 * This interfaces defines a small set of services execution that may be provided
 * by an Eclipse plugin, or may be provided by a standalone implementation.  Among 
 * these services are locating and retrieving strings from the correct resource 
 * bundle for the current locale, and logging errors.
 *  
 * @author Joseph P. Toomey
 * @author Paul E. Slauenwhite
 */
public interface ISystemUtility {
	
	/**
     * Resolves the plugin's resource bundle.
     * <p>
     * If the plugin's resource bundle can not be resolved, <code>null</code> is returned.
     * <p>
     * IMPORTANT: Do not use this method to retrieve values from the resource bundle.  This method 
     * is provided so this plugin's resource bundle can be used as the parent of another plugin's 
     * resource bundle.
     * <p>
     * 
     * @return The plugin's resource bundle, otherwise <code>null</code>.
     * @deprecated As of TPTP V4.4, use the plug-in's resource bundle (e.g. {@link ExecutionHarnessPluginResourceBundle} for this plug-in) for resolving resources in a stand-alone environment.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
	public abstract ResourceBundle getResourceBundle();
	
	/**
     * Resolves the localized message associated with the parameter <code>key</code>
     * based on the default locale from the plugin's resource bundle.
     * <p>
     * If the <code>key</code> does not exist in the plugin's resource bundle, the 
     * <code>key</code> is returned.
     * <p>
     * Noteworthy, the resultant message is not formatted (e.g. no message parameter substitution). 
     * <p>
     * 
     * @param key The <code>key</code> of the message in the plugin's resource bundle.
     * @return The localized message associated with the parameter <code>key</code> from the plugin's resource bundle, otherwise the <code>key</code>.
     * @deprecated As of TPTP V4.4, use the plug-in's resource bundle (e.g. {@link ExecutionHarnessPluginResourceBundle} for this plug-in) for resolving resources in a stand-alone environment.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
	public abstract String getString(String key);
	
	public abstract void logError(Throwable exc);
}