/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRecorderDataProcessor.java,v 1.3 2007/05/02 19:36:13 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder;

import java.io.IOException;


/**
 * Thsi interface is implemented by an object which will handle data passed across
 * the Agent Controller data channel from a RecorderAgent.  This object should be instantiated
 * and added to the Recorder Object
 * for Example:
 * 	new Recorder("org.eclipse.hyades.execution.recorder.http",
 * 				new HttpRecorderDataProcessor(),
 * 				new HttpRecorderAgentEnvironmentAdapter(),
 * 				new HttpRecorderExecutableObjectAdapter());
 * 
 * @see org.eclipse.hyades.execution.recorder.remote.RecorderAgent
 * @see org.eclipse.hyades.execution.recorder.Recorder
 * @author Ernest Jessee
 */
public interface IRecorderDataProcessor
{
	/**
	 * called to initialize the data processor. This api will be called. 
	 * before any data is sent to the object.
	 */
	public void initialize() throws IOException;
	
	/**
	 * called with data sent across the Agent Controller from the RecorderAgent
	 */
	public void processData(byte[] data);
	
	/**
	 * called with a debug String sent across the Agent Controller from the RecorderAgent
	 */
	public void processDebugString(String debugString);
	
	/**
	 * called with a control String sent across the Agent Controller from the RecorderAgent
	 */
	public void processControlString(String controlString);
	
	/**
	 * called when recording is completed, add cleanup here
	 */
	public void complete();
	
}
