/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRecorderListener.java,v 1.2 2009/04/09 18:58:03 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder;

import org.eclipse.hyades.test.core.internal.resources.TestCorePluginResourceBundle;

/**
 * <p>Listener to receive notification of changes in the state (active or inactive) 
 * and status ("Initializing...", "Recording...", or "Stopped") of a {@link Recorder}.</p>
 *  
 *  
 * @author  Jeffrey Nevicosi
 * @author  Paul Slauenwhite
 * @version April 9, 2009
 * @since   April 22, 2005
 */
public interface IRecorderListener{
	
	/**
	 * <p>Receives notification of a change in the state (active or inactive) of a 
	 * {@link Recorder}.</p>
	 *  
	 * @param active <code>true</code> if the state (active or inactive) of the {@link Recorder} is active, otherwise <code>false</code>.
	 */
	public void updateRecorderActive(boolean active);
	
	/**
	 * <p>Receives notification of a change in the status ("Initializing...", "Recording...", or "Stopped") 
	 * of a {@link Recorder}.</p>
	 *  
	 * @param status The new status ("Initializing...", "Recording...", or "Stopped") of the {@link Recorder}.
	 * @see   TestCorePluginResourceBundle#RecorderClient_STATUS_INITIALIZING 
	 * @see   TestCorePluginResourceBundle#RecorderClient_STATUS_RECORDING
	 * @see   TestCorePluginResourceBundle#RecorderClient_STATUS_STOPPED
	 */
	public void updateStatus(String status);
}
