/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRecorderListenerFullFeedback.java,v 1.3 2007/05/02 19:36:13 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder;

/**
 * An extension of the basic IRecorderListener interface, this implements additional 
 * feedback methods that not all listeners will care about.
 * @author jnevicos
 *
 */
public interface IRecorderListenerFullFeedback extends IRecorderListener {

    public static final String KB_RECEIVED = "org.eclipse.hyades.test.core.kb_received";
    public static final String VIEW_MESSAGE = "org.eclipse.hyades.test.core.controlviewmessage";
    
    /**
     * Notifies listeners about message strings. 
     * If UI is to be changed, remember to enclose within a Display.asyncExec()
     * @param key - The type of message (debug messages, etc)
     * @param msg - The contents of the message
     */
	public void controlMessage(String key, String msg);
}
