/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MasterRecorderListener.java
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder;

/**
 * @author jnevicos
 *
 * Specialized Recorder Listener, designed to be used by RecorderClientUI (in test.ui).
 * Not intended to be subclassed by any other class, unless RecorderClientUI is not intended
 * to be used.
 */
public abstract class MasterRecorderListener implements IRecorderListener {

    /* (non-Javadoc)
     * @see org.eclipse.hyades.internal.execution.recorder.IRecorderListener#updateRecorderStatus(boolean)
     */
    public void updateRecorderActive(boolean active) {
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.internal.execution.recorder.IRecorderListener#updateStatus(java.lang.String)
     */
    public void updateStatus(String str) {
    }
    
	public abstract void reportExceptionToUser(final Exception e1,
		     final String consequenceDescription,
		     final String cause,
		     final String dlgTitle);
	
	public abstract void startTestGen();
}
