/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FirefoxAdapter.java,v 1.16 2010/02/22 16:00:05 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.local.appadapters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.core.TestCorePlugin;


/**
 * This object is the client object for a RecorderApplication extension point
 * (point org.eclipse.hyades.execution.recorder.RecorderApplication) it contains
 * logic for initializing, starting, and stopping Firefox. In particular, this
 * object is able to modify user preference settings to cause Firefox to use a
 * particular host and port for proxy recording.
 * <p/>
 * 
 * 
 * @author  Mark D Dunn
 * @author  Paul E. Slauenwhite
 * @version February22, 2010
 * @since   May 25, 2005
 * @deprecated  This is internal API.
 */
public class FirefoxAdapter implements IRecorderApplicationAdapter {
	/**
	 * the Firefox Process
	 */
	private Process firefoxProcess;
	/**
	 * filename for storing the unmodified registry settings
	 */
	private String originalFirefoxDefaultPrefsFileName = "FirefoxOriginalDefaultPrefs.js";//$NON-NLS-1$
	private String originalFirefoxUserPrefsFileName = "FirefoxOriginalUserPrefs.js";//$NON-NLS-1$
	// TODO - determine how to set Java Console
	/**
	 * filname for storing the Firefox Preferences to be used while recording
	 */
	// "C:\Program Files\Mozilla Firefox\firefox.exe"

	private String startupURL = "about:blank";
	private String WindowsLaunchPath = "C:\\Program Files\\Mozilla Firefox\\firefox.exe";
	private String LinuxLaunchPath = "/usr/bin/firefox";
	private String portnum = null;
	private String currentOS = "";
	boolean isProxyEnabled = false;
	File mozDefaultPrefsFile = null;
	File mozUserPrefsFile = null;
	boolean foundDefaultFile = false;
	boolean foundUserFile = false;
	public FirefoxPrefs prefsToUse = null;
	public FirefoxPrefs myMozDefaultPrefs = null;
	public FirefoxPrefs myMozUserPrefs = null;
	public String RecorderPathFileStr = "";
	public String recorderPathFileName = "recorderPathFile";
		
	public static final String PREFERENCE_PATH = "RECORDER_FIREFOX_PATH";

	/**
	 * init routine called by the recorder to have firefox prepared for
	 * recording
	 * 
	 * @param String
	 *            initInfo -- this is a comma delimeted string indicating which
	 *            port to point IE at. (ie. port,1080)
	 */
	String initString = "";
	public final int PROXY_SETTINGS_OK = 0;
	public final int SOCKS_SET = -1;
	public final int HTTP_PROXY_ONLY_SET = -2;
	public final int SECURE_PROXY_ONLY_SET = -3;
	public final int HTTP_SECURE_MISMATCH = -4;
	public final int HTTP_SECURE_LOCALHOST = -5;
	public final int HTTP_PROXY_OVERRIDE = -6;
	public final int AUTO_CONFIG_URL = -7;

	public void init(String initInfo)
			throws RecorderApplicationAdapterException {
		
		parseInitInfo(initInfo);
		prefsToUse = new FirefoxPrefs();
		// bugzilla defect 105953
		File testBrowser = new File (getApplicationPath());
		if (!testBrowser.exists()){
			if (prefsToUse != null){
				prefsToUse.setAdapterProblem(true);
				prefsToUse.setAdapterError(prefsToUse.BROWSER_NOT_FOUND);
			}
		}
	}

	public StringBuffer getRecFileContent(String recFilePath) {

		InputStreamReader inputReader = null;
		File file = null;
		StringBuffer inputFileContents = new StringBuffer();
		char[] inputBuf = new char[1000];
		int bytesRead = 0;
		try {
			file = new File(recFilePath);
			if (!file.exists()) {
				return null;
			}

			inputReader = new InputStreamReader(new FileInputStream(file));
			bytesRead = inputReader.read(inputBuf);

			while (bytesRead != -1) {
				inputFileContents.append(inputBuf, 0, bytesRead);
				bytesRead = inputReader.read(inputBuf);
			}
			inputReader.close();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (inputReader != null)
				try {
					inputReader.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
		}
		return inputFileContents;
	}
	public String scanRecFileContent(StringBuffer recFileContents) {
		// scan file
		String returnedPath = "";
		String tmpPath = "";
		String firefoxStr = "Firefox:";
		StringTokenizer fileTokenizer = new StringTokenizer(recFileContents.toString(), "\r\n");//$NON-NLS-1$
		while (fileTokenizer.hasMoreTokens()) {
			String line = fileTokenizer.nextToken();
			if (line.startsWith(firefoxStr)){
				tmpPath = line.substring(firefoxStr.length());
				tmpPath = tmpPath.trim();
				returnedPath = tmpPath;
				break;
			}
		}
		return returnedPath;
	}

	/**
	 * method called by the recorder to start the target application (Internet
	 * Explorer)
	 * 
	 * @return Process
	 */
	public Process start() throws RecorderApplicationAdapterException {
		firefoxProcess = null;
		try {
			// TODO derive path to firefox.exe using registry.
			// ieProcess = Runtime.getRuntime().exec(launchPath + " " +
			// startupURL);//$NON-NLS-1$
			//	 bugzilla 150825 mddunn july 17,2006
			if ((startupURL != null) && (startupURL.length()> 0)) {
				int findBlank = -1;
				findBlank = startupURL.indexOf(" ");
				if (findBlank != -1)
					startupURL = "\"" + startupURL + "\"";
			}
			firefoxProcess = Runtime.getRuntime().exec(
					getApplicationPath() + " " +  startupURL);//$NON-NLS-1$
		} catch (IOException e) {
			throw new RecorderApplicationAdapterException(
					"unable to start Firefox Process: " + e.getMessage());//$NON-NLS-1$
		}
		return firefoxProcess;
	}

	/**
	 * method called to restore the process back to its original state
	 */
	public void cleanup() throws RecorderApplicationAdapterException {
		// delete the new user.js
		// delete the new prefs.js
		// rename originalDefaultprefs.js to prefs.js
		// rename originalUserPrefs.js to user.js
		// .../user.js

		//	 TPTP recorder generated .../user.js  User file 
		File newTPTPGeneratedUserPrefs = new File(prefsToUse.firefoxUserPrefsPath); 
		
		// Original User Prefs File (user.js) backed up earlier ...\FirefoxOriginalUserPrefs.js
		File originalUserPrefs = new File (prefsToUse.firefoxUserPrefsPathDir + originalFirefoxUserPrefsFileName);
		
		// newly generated (by firefox due to TPTP setting ...\prefs.js
		File newTPTPGeneratedDefaultPrefs = new File(prefsToUse.firefoxDefaultPrefsPath);
		
		//	 Original Firefox Default (prefs.js) file backed up earlier ...\FirefoxOriginalDefaultPrefs.js
		File originalDefaultPrefs = new File (prefsToUse.firefoxDefaultPrefsPathDir + originalFirefoxDefaultPrefsFileName);
		// NEW begin
		// this is FirefoxOriginalDefaultPrefs.js
		if (originalDefaultPrefs.exists()){
			// we have an abort - there is a FirefoxOriginalDefaultPrefs.js
			// Delete prefs.js, and rename FirefoxOriginalDefaultPrefs.js to prefs.js
			if (newTPTPGeneratedDefaultPrefs.exists()){
				newTPTPGeneratedDefaultPrefs.delete();
			}
			originalDefaultPrefs.renameTo(newTPTPGeneratedDefaultPrefs);
			// next, check user.js file
			if (originalUserPrefs.exists()){
				// must delete user.js and rename FirefoxOriginalUserPrefs.js to user.js
				if (newTPTPGeneratedUserPrefs.exists()){
					newTPTPGeneratedUserPrefs.delete();
				}
				originalUserPrefs.renameTo(newTPTPGeneratedUserPrefs);
			} else {
				// just delete user.js if it is there
				if (newTPTPGeneratedUserPrefs.exists()){
					newTPTPGeneratedUserPrefs.delete();
				}
			}
		}
	}


	/**
	 * method called to stop the target process.
	 */
	public void stop() throws RecorderApplicationAdapterException {
		firefoxProcess.destroy();
	}

	// init format:
	// param,value;param,value
	// Params:
	// port - proxy port
	// startupURL - page to launch IE with (file protocol only)
	private void parseInitInfo(String initInfo) {
		portnum = "";
		startupURL = "";
		StringTokenizer tok = new StringTokenizer(initInfo, ";");
		while (tok.hasMoreTokens()) {
			String curTokn = tok.nextToken();
			StringTokenizer tok2 = new StringTokenizer(curTokn, ",");
			String key = tok2.nextToken();
			String val = tok2.nextToken();
			if (key.equals("port")) {
				portnum = val;
				try {
					Integer.parseInt(portnum);
				} catch (NumberFormatException e) {
					// error condition, should maybe just exit?
					portnum = "443";
				}
			} else if (key.equals("startupURL")) {
				startupURL = val;
			} 
		}
	}


	public void setInitString(String initString) {
		this.initString = initString;
	}

	/**
	 * called by the recorder to acquire the adapters init string for passing to
	 * the agent side of the rac
	 */
	public String getInitString() {
		return initString;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.local.appadapters.IRecorderApplicationAdapter#getApplicationPath()
	 */
	public String getApplicationPath() {
		String str = TestCorePlugin.getDefault().getPluginPreferences().getString(PREFERENCE_PATH);
		if (str == null || str.length() == 0)
			return getDefaultApplicationPath();
		else 
			return str;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.local.appadapters.IRecorderApplicationAdapter#getDefaultApplicationPath()
	 */
	public String getDefaultApplicationPath() {
		currentOS = Platform.getOS();
		
		if (currentOS.equals("win32")) {
			// bugzilla 133959 mdd make sure default it valid
			File browserApp = new File(WindowsLaunchPath);
			if (browserApp.exists())
				return WindowsLaunchPath;
			else
				return "";
		} else if (currentOS.equals("linux")) {
			// bugzilla 133959 mdd make sure default it valid
			File browserApp = new File(LinuxLaunchPath);
			if (browserApp.exists())
				return LinuxLaunchPath;
			else
				return "";
		}
		return null;
	}
	
	public void setApplicationPath(String str) {
		if ( (str != null) && str.length() > 0) {
			TestCorePlugin.getDefault().getPluginPreferences().setValue(PREFERENCE_PATH, str);
		}
		else {
			String newPath = getDefaultApplicationPath();
			TestCorePlugin.getDefault().getPluginPreferences().setValue(PREFERENCE_PATH, newPath);
		}
	}
}
