/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FirefoxPrefs.java,v 1.22 2010/02/22 16:00:05 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.local.appadapters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.core.TestCorePlugin;


/**
 * This object is the support methods for the FireFoxAdapter.  In particular, this
 * object is able to read and modify user preference settings to cause Firefox to use a
 * particular host and port for proxy recording.
 * <p/>
 * 
 * 
 * @author  Mark D Dunn
 * @author  Paul E. Slauenwhite
 * @version February 22, 2010
 * @since   May 25, 2005
 * @deprecated  This is internal API.
 */

public class FirefoxPrefs {
	// scan file
	// user_pref("network.proxy.http", "CleteDunn");
	// user_pref("network.proxy.no_proxies_on", "");
	// user_pref("network.proxy.socks", "127.0.0.1");
	// user_pref("network.proxy.socks_port", 1080);
	// user_pref("network.proxy.socks_version", 4);
	// user_pref("network.proxy.type", 1);
	// user_pref("browser.startup.homepage", "http://w3.ibm.com");

	final String FIND_HTTP_PROXY = "user_pref(\"network.proxy.http\",";
	final String FIND_HTTP_PROXY_PORT = "user_pref(\"network.proxy.http_port\",";
	final String FIND_PROXY_OVERRIDE = "user_pref(\"network.proxy.no_proxies_on\",";
	final String FIND_SOCKS_PROXY = "user_pref(\"network.proxy.socks\",";
	final String FIND_SOCKS_PROXY_PORT = "user_pref(\"network.proxy.socks_port\",";
	final String FIND_SOCKS_VERSION = "user_pref(\"network.proxy.socks_version\",";
	final String FIND_HOMEPAGE = "user_pref(\"browser.startup.homepage\",";
	final String FIND_SSL_PROXY = "user_pref(\"network.proxy.ssl\",";
	final String FIND_SSL_PROXY_PORT = "user_pref(\"network.proxy.ssl_port\",";
	final String FIND_AUTO_CONFIG_URL = "user_pref(\"network.proxy.autoconfig_url\",";
	final String FIND_NETWORK_PROXY_TYPE = "user_pref(\"network.proxy.type\",";
	final String FIND_NETWORK_HTTP_PROXY_SSL = "user_pref(\"network.http.proxy.ssl\",";
	// network.proxy.type: 0 - Unused/Unset 1 -Manual 2-Automatic 3-None
	private String proxyType = "";
	private String httpProxyAddr = "";
	private String httpProxyPort = "";
	private boolean isHttpProxyEnabled = false;
	private boolean badProxySettings = false;
	private boolean isAdapterProblem = false;
	private int proxyError = -1;
	private boolean isAutoConfigURLEnabled = false;
	private boolean isProxyOverrideEnabled = false;
	private String autoConfigURLEnabledValue = "";
	private String homePage = "";
	private String socksVersion = "";
	private boolean isSocksProxyEnabled = false;
	private String socksProxyAddr = "";
	private String socksProxyPort = "";
	private String proxyOverrideAddr = "";
	public final int PROXY_SETTINGS_OK = 0;
	public final int SOCKS_SET = -1;
	public final int HTTP_PROXY_ONLY_SET = -2;
	public final int SECURE_PROXY_ONLY_SET = -3;
	public final int HTTP_SECURE_MISMATCH = -4;
	public final int HTTP_SECURE_LOCALHOST = -5;
	public final int HTTP_PROXY_OVERRIDE = -6;
	public final int AUTO_CONFIG_URL = -7;
	// bugzilla 105953
	public final int PREFS_NOT_FOUND = -8;
	//	bugzilla 106791
	public final int BROWSER_NOT_FOUND = -9;
	// bugzilla 177340
	/**
	 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public final int BROWSER_IN_USE = -10;

	private String sslProxyAddr = "";
	private String sslProxyPort = "";
	private boolean isSSLProxyEnabled = false;
	private String startupURL = "about:blank";
	private String WindowsLaunchPath = "C:\\Program Files\\Mozilla Firefox\\firefox.exe";
	private String LinuxLaunchPath = "/usr/bin/firefox";
	private String launchPath = "";
	private String originalFirefoxDefaultPrefsFileName = "FirefoxOriginalDefaultPrefs.js";//$NON-NLS-1$
	private String originalFirefoxUserPrefsFileName = "FirefoxOriginalUserPrefs.js";//$NON-NLS-1$
	private String tempFirefoxUserPrefsFileName = "tempFirefoxUserPrefs.js";//$NON-NLS-1$
	// TODO defect 78895 below - also enable java console
	public String firefoxDefaultPrefsPath = "";
	public String firefoxUserPrefsPath = "";
	public String firefoxDefaultPrefsPathDir = "";
	public String firefoxUserPrefsPathDir = "";
	public String firefoxPrefsFilePath = "";
	private String userHome = "";
	private String userName = "";
	private String currentOS = "";
	private String separatorChar = "";
	boolean isProxyEnabled = false;
	private boolean isBadProxyError = false;
	// need these to reconcile User and Default prefs
	private boolean foundHttpProxyAddr = false;
	private boolean foundHttpProxyPort = false;
	private boolean foundProxyOverrideAddr = false;
	private boolean foundSocksProxyPort = false;
	private boolean foundSocksProxyAddr = false;
	private boolean foundSocksVersion = false;
	private boolean foundHomePage = false;
	private boolean foundSslProxyAddr = false;
	private boolean foundSslProxyPort = false;
	private boolean foundAutoConfigURLEnabled = false;
	private boolean foundHttpProxyType = false;
	private int listenPort = -1;
	private int adapterError = -1;
	private String sslKeyFilePath = "";
	private String RecorderPathFileStr = "";
	private String recorderPathFileName = "recorderPathFile";
	// bugzilla 131548 browser not found
	public static final String PREFERENCE_PATH = "RECORDER_FIREFOX_PATH";
	// bugzilla 165310
	/**
	 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
	 */
	public static final String mylocalhost = "127.0.0.1";
	// Strings below for bugzilla 177340
	final String PROFILES_INI_NAME = "Name=";
	final String PROFILES_INI_RELATIVE = "IsRelative=";
	final String PROFILES_INI_PATH = "Path=";
	final String PROFILES_INI_DEFAULT = "Default=1";
	final String PROFILES_INI_PROFILE = "[Profile";
	private String firefoxPrefsBasePath="";
	private String firefoxLinuxLockFile = "lock";
	private String firefoxWindowsLockFile = "parent.lock";
	
	public FirefoxPrefs() {
		init(false);
	}
	public FirefoxPrefs(int proxyPort) {
		boolean browserPathOK = false;
		listenPort = proxyPort;
		init(false);
		// bugzilla 121068 mdd
		if (!((badProxySettings == true) && (proxyError == this.PREFS_NOT_FOUND)))
		    getPrefsToUse();
		// bugzilla 131548 browser not found
		browserPathOK = checkBrowserLaunchPath();
		if (!browserPathOK){
			setBadProxySettings(true);
			setProxyError(BROWSER_NOT_FOUND);
		}
	}
	public FirefoxPrefs(int proxyPort,boolean checkAbortStatus) {
		boolean browserPathOK = false;
		listenPort = proxyPort;
		init(checkAbortStatus);
		if ((badProxySettings == true) && (proxyError == this.BROWSER_IN_USE)){
			return;
		}
		// bugzilla 121068 mdd
		if (!((badProxySettings == true) && (proxyError == this.PREFS_NOT_FOUND)))
		    getPrefsToUse();
		// bugzilla 131548 browser not found
		browserPathOK = checkBrowserLaunchPath();
		if (!browserPathOK){
			setBadProxySettings(true);
			setProxyError(BROWSER_NOT_FOUND);
		}
	}
	private boolean checkBrowserLaunchPath() {
		// bugzilla 131548 browser not found
		File testBrowser = new File (getApplicationPath());
		if (!testBrowser.exists()){
			return false;
		}
		return true;
	}
	public String getApplicationPath() {
		String str = TestCorePlugin.getDefault().getPluginPreferences().getString(PREFERENCE_PATH);
		if (str == null || str.length() == 0)
			return getDefaultApplicationPath();
		else 
			return str;
	}
	public FirefoxPrefs(int proxyPort, String sslKeyFilePath) {
		
		listenPort = proxyPort;
		init(false);

		getPrefsToUse(); 
		this.sslKeyFilePath = sslKeyFilePath;
		// bugzilla 105953
		checkLaunchPath();
	}
	private void checkLaunchPath() {
		String newLaunchPath = "";
		if ((sslKeyFilePath != null) && (sslKeyFilePath.length() <= 0)) {
			return;
		}
		currentOS = Platform.getOS();
		
		if (currentOS.equals("win32")) {
			separatorChar = "\\";
			launchPath = WindowsLaunchPath; 
		} else if (currentOS.equals("linux")) {
			separatorChar = "/";
		}
		newLaunchPath = findNewLaunchPath(sslKeyFilePath);
		if (newLaunchPath.length()>0) {
			launchPath = newLaunchPath;
		}
		File testBrowser = new File (launchPath);
		if (!testBrowser.exists()){
			setAdapterProblem(true);
			setAdapterError(BROWSER_NOT_FOUND);
		}
		
	}
	public FirefoxPrefs(String thePrefsFilePath)  {
		firefoxPrefsFilePath = thePrefsFilePath;
		firefoxDefaultPrefsPath = getDefaultPrefsPath();
		if ((firefoxDefaultPrefsPath == ((String)null)) || firefoxDefaultPrefsPath.length() == 0) {
			setAdapterProblem(true);
			setAdapterError(PREFS_NOT_FOUND);
		}
		else {	
			firefoxUserPrefsPath = getUserPrefsPath();
			StringBuffer prefsContent = getPrefsContent(thePrefsFilePath);
			//	 bugzilla 105953
			if (prefsContent == null){
				setAdapterProblem(true);
				setAdapterError(PREFS_NOT_FOUND);
			}
			else {
				scanPrefsContent(prefsContent);
				isConfigValid();
			}
		}
	}

	public void scanPrefsContent(StringBuffer prefsFileContents) {
		// scan file
		// user_pref("network.proxy.http", "CleteDunn");
		// user_pref("network.proxy.no_proxies_on", "");
		// user_pref("network.proxy.socks", "127.0.0.1");
		// user_pref("network.proxy.socks_port", 1080);
		// user_pref("network.proxy.socks_version", 4);
		// user_pref("network.proxy.type", 1);
		StringTokenizer fileTokenizer = new StringTokenizer(prefsFileContents.toString(), "\r\n");//$NON-NLS-1$
		while (fileTokenizer.hasMoreTokens()) {
			String line = fileTokenizer.nextToken();
			String thisVal;
			if (line.startsWith(FIND_HTTP_PROXY)) {
				foundHttpProxyAddr = true;
				thisVal = getValue(line, FIND_HTTP_PROXY);
				if (thisVal.length() >= 1) {
					httpProxyAddr = thisVal;
				}
			} else if (line.startsWith(FIND_HTTP_PROXY_PORT)) {
				thisVal = getValueNumber(line, FIND_HTTP_PROXY_PORT);
				foundHttpProxyPort = true;
				if (thisVal.length() >= 1) {
					httpProxyPort = thisVal;
				}
			} else if (line.startsWith(FIND_PROXY_OVERRIDE)) {
				foundProxyOverrideAddr = true;
				thisVal = getValue(line, FIND_PROXY_OVERRIDE);
				if (thisVal.length() >= 1) {
					proxyOverrideAddr = thisVal;
					isProxyOverrideEnabled = true;
				}
			} else if (line.startsWith(FIND_SOCKS_PROXY_PORT)) {
				foundSocksProxyPort = true;
				thisVal = getValueNumber(line, FIND_SOCKS_PROXY_PORT);
				if (thisVal.length() >= 1) {
					socksProxyPort = thisVal;
				}
			} else if (line.startsWith(FIND_SOCKS_PROXY)) {
				foundSocksProxyAddr = true;
				thisVal = getValue(line, FIND_SOCKS_PROXY);
				if (thisVal.length() >= 1) {
					socksProxyAddr = thisVal;
				}
			} else if (line.startsWith(FIND_SOCKS_VERSION)) {
				thisVal = getValueNumber(line, FIND_SOCKS_VERSION);
				foundSocksVersion = true;
				if (thisVal.length() >= 1) {
					socksVersion = thisVal;
				}
			} else if (line.startsWith(FIND_HOMEPAGE)) {
				foundHomePage = true;
				thisVal = getValue(line, FIND_HOMEPAGE);
				if (thisVal.length() >= 1) {
					homePage = thisVal;
				}
			} else if (line.startsWith(FIND_SSL_PROXY)) {
				foundSslProxyAddr=true;
				thisVal = getValue(line, FIND_SSL_PROXY);
				if (thisVal.length() >= 1) {
					sslProxyAddr = thisVal;
				}
			} else if (line.startsWith(FIND_SSL_PROXY_PORT)) {
				foundSslProxyPort = true;
				thisVal = getValueNumber(line, FIND_SSL_PROXY_PORT);
				if (thisVal.length() >= 1) {
					sslProxyPort = thisVal;
				}

			} else if (line.startsWith(FIND_AUTO_CONFIG_URL)) {
				thisVal = getValue(line, FIND_AUTO_CONFIG_URL);
				isAutoConfigURLEnabled = true;
				autoConfigURLEnabledValue = thisVal;
				foundAutoConfigURLEnabled = true;
			} else if (line.startsWith(FIND_NETWORK_PROXY_TYPE)) {
				thisVal = getValueNumber(line, FIND_NETWORK_PROXY_TYPE);
				proxyType = thisVal;
				foundHttpProxyType = true;
				if (proxyType.equals("1")) {
					isProxyEnabled = true;
				}
			}
		}
		// Now determine if http and ssl proxies are enabled 
		if (isProxyEnabled){
			if ( (httpProxyAddr.length() > 0 ) && (httpProxyPort.length() > 0)){
				isHttpProxyEnabled = true;
			}
			if ( (sslProxyAddr.length() > 0 ) && (sslProxyPort.length() > 0)){
				isSSLProxyEnabled = true;
			}
			if ( (socksProxyAddr.length() > 0 ) && (socksProxyPort.length() > 0)){
				isSocksProxyEnabled = true;
			}
		}

	}
	// return a copy of the prefs sent in
	public FirefoxPrefs(FirefoxPrefs originalPrefs) {
		proxyType = originalPrefs.proxyType;
		httpProxyAddr = originalPrefs.httpProxyAddr;
		httpProxyPort = originalPrefs.httpProxyPort;
		isHttpProxyEnabled = originalPrefs.isHttpProxyEnabled;
		badProxySettings = originalPrefs.badProxySettings;
		proxyError = originalPrefs.proxyError;
		isAutoConfigURLEnabled = originalPrefs.isAutoConfigURLEnabled;
		isProxyOverrideEnabled = originalPrefs.isProxyOverrideEnabled;
		autoConfigURLEnabledValue = originalPrefs.autoConfigURLEnabledValue;
		homePage = originalPrefs.homePage;
		socksVersion = originalPrefs.socksVersion;
		isSocksProxyEnabled = originalPrefs.isSocksProxyEnabled;
		socksProxyAddr = originalPrefs.socksProxyAddr;
		socksProxyPort = originalPrefs.socksProxyPort;
		proxyOverrideAddr = originalPrefs.proxyOverrideAddr;
		sslProxyAddr = originalPrefs.sslProxyAddr;
		sslProxyPort = originalPrefs.sslProxyPort;
		isSSLProxyEnabled = originalPrefs.isSSLProxyEnabled;
		startupURL = originalPrefs.startupURL;
		WindowsLaunchPath = originalPrefs.WindowsLaunchPath;
		LinuxLaunchPath = originalPrefs.LinuxLaunchPath;
		launchPath = originalPrefs.launchPath;
		firefoxDefaultPrefsPath = originalPrefs.firefoxDefaultPrefsPath;
		firefoxUserPrefsPath = originalPrefs.firefoxUserPrefsPath;
		firefoxDefaultPrefsPathDir = originalPrefs.firefoxDefaultPrefsPathDir;
		firefoxUserPrefsPathDir = originalPrefs.firefoxUserPrefsPathDir;
		firefoxPrefsFilePath = originalPrefs.firefoxPrefsFilePath;
		userHome = originalPrefs.userHome;
		userName = originalPrefs.userName;
		currentOS = originalPrefs.currentOS;
		separatorChar = originalPrefs.separatorChar;
		isProxyEnabled = originalPrefs.isProxyEnabled;
		isBadProxyError = originalPrefs.isBadProxyError;
		foundHttpProxyAddr = originalPrefs.foundHttpProxyAddr;
		foundHttpProxyPort = originalPrefs.foundHttpProxyPort;
		foundProxyOverrideAddr = originalPrefs.foundProxyOverrideAddr;
		foundSocksProxyPort = originalPrefs.foundSocksProxyPort;
		foundSocksProxyAddr = originalPrefs.foundSocksProxyAddr;
		foundSocksVersion = originalPrefs.foundSocksVersion;
		foundHomePage = originalPrefs.foundHomePage;
		foundSslProxyAddr = originalPrefs.foundSslProxyAddr;
		foundSslProxyPort = originalPrefs.foundSslProxyPort;
		foundAutoConfigURLEnabled = originalPrefs.foundAutoConfigURLEnabled;
		foundHttpProxyType = originalPrefs.foundHttpProxyType;
		listenPort = originalPrefs.listenPort;
		sslKeyFilePath = originalPrefs.sslKeyFilePath;
		firefoxPrefsBasePath = originalPrefs.firefoxPrefsBasePath;

	}
	// set current prefs to the prefs sent in
	public void setCurrentPrefs(FirefoxPrefs newPrefs) {
		if (newPrefs != null) {
			proxyType = newPrefs.proxyType;
			httpProxyAddr = newPrefs.httpProxyAddr;
			httpProxyPort = newPrefs.httpProxyPort;
			isHttpProxyEnabled = newPrefs.isHttpProxyEnabled;
			badProxySettings = newPrefs.badProxySettings;
			proxyError = newPrefs.proxyError;
			isAutoConfigURLEnabled = newPrefs.isAutoConfigURLEnabled;
			isProxyOverrideEnabled = newPrefs.isProxyOverrideEnabled;
			autoConfigURLEnabledValue = newPrefs.autoConfigURLEnabledValue;
			homePage = newPrefs.homePage;
			socksVersion = newPrefs.socksVersion;
			isSocksProxyEnabled = newPrefs.isSocksProxyEnabled;
			socksProxyAddr = newPrefs.socksProxyAddr;
			socksProxyPort = newPrefs.socksProxyPort;
			proxyOverrideAddr = newPrefs.proxyOverrideAddr;
			sslProxyAddr = newPrefs.sslProxyAddr;
			sslProxyPort = newPrefs.sslProxyPort;
			isSSLProxyEnabled = newPrefs.isSSLProxyEnabled;
			startupURL = newPrefs.startupURL;
			WindowsLaunchPath = newPrefs.WindowsLaunchPath;
			LinuxLaunchPath = newPrefs.LinuxLaunchPath;
			launchPath = newPrefs.launchPath;
			firefoxDefaultPrefsPath = newPrefs.firefoxDefaultPrefsPath;
			firefoxUserPrefsPath = newPrefs.firefoxUserPrefsPath;
			firefoxDefaultPrefsPathDir = newPrefs.firefoxDefaultPrefsPathDir;
			firefoxUserPrefsPathDir = newPrefs.firefoxUserPrefsPathDir;
			firefoxPrefsFilePath = newPrefs.firefoxPrefsFilePath;
			userHome = newPrefs.userHome;
			userName = newPrefs.userName;
			currentOS = newPrefs.currentOS;
			separatorChar = newPrefs.separatorChar;
			isProxyEnabled = newPrefs.isProxyEnabled;
			isBadProxyError = newPrefs.isBadProxyError;
			foundHttpProxyAddr = newPrefs.foundHttpProxyAddr;
			foundHttpProxyPort = newPrefs.foundHttpProxyPort;
			foundProxyOverrideAddr = newPrefs.foundProxyOverrideAddr;
			foundSocksProxyPort = newPrefs.foundSocksProxyPort;
			foundSocksProxyAddr = newPrefs.foundSocksProxyAddr;
			foundSocksVersion = newPrefs.foundSocksVersion;
			foundHomePage = newPrefs.foundHomePage;
			foundSslProxyAddr = newPrefs.foundSslProxyAddr;
			foundSslProxyPort = newPrefs.foundSslProxyPort;
			foundAutoConfigURLEnabled = newPrefs.foundAutoConfigURLEnabled;
			foundHttpProxyType = newPrefs.foundHttpProxyType;
			listenPort = newPrefs.listenPort;
			sslKeyFilePath = newPrefs.sslKeyFilePath;
			firefoxPrefsBasePath = newPrefs.firefoxPrefsBasePath;
		}
	}
	public void init(boolean checkAbortFlag) {

		currentOS = Platform.getOS();

		if (currentOS.equals("win32")) {
			separatorChar = "\\";
			launchPath = WindowsLaunchPath;
		} else if (currentOS.equals("linux")) {
			separatorChar = "/";
			launchPath = LinuxLaunchPath;
		}
		// Linux example - /home/mdunn/.firefox/default/sb0nt166.slt/prefs.js
		// /home/mdunn/.mozilla/wx35y7kb.slt/prefs.js

		userHome = System.getProperty("user.home");
		userName = System.getProperty("user.name");
		// also sets firefoxxxxPrefsPathDir  
		firefoxDefaultPrefsPath = getDefaultPrefsPath();
		//	 bugzilla 121068 mdd
		if ((firefoxDefaultPrefsPath == (String)null) ||(firefoxDefaultPrefsPath.length()== 0)) {
			this.proxyError = this.PREFS_NOT_FOUND;
			this.badProxySettings = true;
			setAdapterProblem(true);
		} 
		else if (browserInUse()) {
			this.proxyError = this.BROWSER_IN_USE;
			this.badProxySettings = true;
			setAdapterProblem(true);
		}
		else {
			firefoxUserPrefsPath = getUserPrefsPath();
		}
		if (checkAbortFlag){
			checkAndFixAbortStatus();
		}
	}
	
	// bugzilla 177340 mdd 04/27/2007
	private boolean browserInUse() {
		String lockFilePath = "";
		boolean lockedFile = false;
		if (currentOS.equals("win32")) {
			lockFilePath = firefoxPrefsBasePath + firefoxWindowsLockFile;
			File lockFile = new File(lockFilePath);
			if (lockFile.exists()){
				lockedFile= true;
			}
		} else if (currentOS.equals("linux")) {
			String thisFile = "";
			lockFilePath =  firefoxPrefsBasePath + firefoxLinuxLockFile ;
			File baseDir = new File(firefoxPrefsBasePath);
			if (baseDir.exists()){
				String[] allFiles = baseDir.list();
				for (int i = 0; i < allFiles.length; i++){
					thisFile = allFiles[i];
					if (thisFile.startsWith(firefoxLinuxLockFile)){
						lockedFile = true;
						break;
					}
				}
				
			}
		}
		
		return lockedFile;
	}
	public FirefoxPrefs getPrefsToUse(){
		FirefoxPrefs usePrefs = null;
		File mozDefaultPrefsFile = null;
		File mozUserPrefsFile = null;
		FirefoxPrefs myMozDefaultPrefs = null;
		FirefoxPrefs myMozUserPrefs = null;
		FirefoxPrefs prefsToUse = null; 
		
		// 121068 mdd
		if ((this.badProxySettings) && (this.proxyError == this.PREFS_NOT_FOUND)){
			// can not continue 
			return this;
		}
		mozDefaultPrefsFile = new File(firefoxDefaultPrefsPath);
		mozUserPrefsFile = new File(firefoxUserPrefsPath);
		if (mozDefaultPrefsFile.exists()){
			myMozDefaultPrefs = new FirefoxPrefs(firefoxDefaultPrefsPath);
		}
		else {
			setAdapterProblem(true);
			setAdapterError(PREFS_NOT_FOUND);
		}
		if (mozUserPrefsFile.exists()){
			myMozUserPrefs = new FirefoxPrefs(firefoxUserPrefsPath);
		}

		if ((myMozDefaultPrefs != null) && (myMozUserPrefs != null)) {
			// have them both, must reconcile
			prefsToUse = new FirefoxPrefs (myMozDefaultPrefs, myMozUserPrefs);
		} else if (myMozDefaultPrefs != null) {
			prefsToUse = myMozDefaultPrefs;
		} else {
			prefsToUse = myMozUserPrefs;

		}	
		if (prefsToUse == null){
			prefsToUse = this;
		}
		setCurrentPrefs(prefsToUse);
		isConfigValid();
		StringBuffer newPrefsBuffer = null;
		boolean isProxyBad =  prefsToUse.isBadProxySettings();
		boolean isBrowserProblem =  prefsToUse.isAdapterProblem();
		if (!isProxyBad  && !isBrowserProblem) {
			newPrefsBuffer = generateNewPrefsBuffer();
			createPrefsSettingsFile(newPrefsBuffer);
		}
		usePrefs = prefsToUse;
		return usePrefs;
	}

	private String getValue(String thisLine, String thisKey) {
		String returnValue = "";
		String tmp = thisLine;
		int keyLen = thisKey.length();
		int thisLen = thisLine.length();
		if (keyLen > thisLen) {
			return null;
		}
		// first have "user_pref("network.proxy.http", "Clete Dunn");
		int nextPos = tmp.indexOf(thisKey);
		nextPos += keyLen;
		String tmp2 = tmp.substring(nextPos, thisLen);
		// now have "Clete Dunn");
		int firstQuote = tmp2.indexOf("\"");
		int secondQuote = tmp2.indexOf("\"", firstQuote + 1);
		String tmpVal = tmp2.substring(firstQuote + 1, secondQuote);
		returnValue = tmpVal;

		return returnValue;
	}

	private String getValueNumber(String thisLine, String thisKey) {
		String returnValue = "";
		String tmp = thisLine;
		int keyLen = thisKey.length();
		int thisLen = thisLine.length();
		if (keyLen > thisLen) {
			return null;
		}
		// first have "user_pref("network.proxy.http", "Clete Dunn");
		int nextPos = tmp.indexOf(thisKey);
		nextPos += keyLen;
		String tmp2 = tmp.substring(nextPos, thisLen);
		// now have " 1080);");
		tmp2 = tmp2.trim();
		int rightParen = tmp2.indexOf(")");

		String tmpVal = tmp2.substring(0, rightParen);
		returnValue = tmpVal;

		return returnValue;
	}

	public int getAUTO_CONFIG_URL() {
		return AUTO_CONFIG_URL;
	}

	public String getAutoConfigURLEnabledValue() {
		return autoConfigURLEnabledValue;
	}

	public boolean isBadProxySettings() {
		return badProxySettings;
	}

	public String getFIND_AUTO_CONFIG_URL() {
		return FIND_AUTO_CONFIG_URL;
	}

	public String getFIND_HOMEPAGE() {
		return FIND_HOMEPAGE;
	}

	public String getFIND_HTTP_PROXY() {
		return FIND_HTTP_PROXY;
	}

	public String getFIND_HTTP_PROXY_PORT() {
		return FIND_HTTP_PROXY_PORT;
	}

	public String getFIND_PROXY_OVERRIDE() {
		return FIND_PROXY_OVERRIDE;
	}

	public String getFIND_SOCKS_PROXY() {
		return FIND_SOCKS_PROXY;
	}

	public String getFIND_SOCKS_PROXY_PORT() {
		return FIND_SOCKS_PROXY_PORT;
	}

	public String getFIND_SOCKS_VERSION() {
		return FIND_SOCKS_VERSION;
	}

	public String getFIND_SSL_PROXY() {
		return FIND_SSL_PROXY;
	}

	public String getFIND_SSL_PROXY_PORT() {
		return FIND_SSL_PROXY_PORT;
	}

	public String getHomePage() {
		return homePage;
	}

	public int getHTTP_PROXY_ONLY_SET() {
		return HTTP_PROXY_ONLY_SET;
	}

	public int getHTTP_PROXY_OVERRIDE() {
		return HTTP_PROXY_OVERRIDE;
	}

	public int getHTTP_SECURE_LOCALHOST() {
		return HTTP_SECURE_LOCALHOST;
	}

	public int getHTTP_SECURE_MISMATCH() {
		return HTTP_SECURE_MISMATCH;
	}

	public String getHttpProxyAddr() {
		return httpProxyAddr;
	}

	public String getHttpProxyPort() {
		return httpProxyPort;
	}

	public boolean isAutoConfigURLEnabled() {
		return isAutoConfigURLEnabled;
	}

	public boolean isHttpProxyEnabled() {
		return isHttpProxyEnabled;
	}

	public boolean isProxyOverrideEnabled() {
		return isProxyOverrideEnabled;
	}

	public boolean isSocksProxyEnabled() {
		return isSocksProxyEnabled;
	}

	public boolean isSSLProxyEnabled() {
		return isSSLProxyEnabled;
	}

	public int getProxyError() {
		return proxyError;
	}
	
	public int getAdapterError() {
		return adapterError;
	}

	public String getProxyOverrideAddr() {
		return proxyOverrideAddr;
	}

	public String getProxyType() {
		return proxyType;
	}

	public int getSECURE_PROXY_ONLY_SET() {
		return SECURE_PROXY_ONLY_SET;
	}

	public int getSOCKS_SET() {
		return SOCKS_SET;
	}

	public String getSocksProxyAddr() {
		return socksProxyAddr;
	}

	public String getSocksProxyPort() {
		return socksProxyPort;
	}

	public String getSocksVersion() {
		return socksVersion;
	}

	public String getSslProxyAddr() {
		return sslProxyAddr;
	}

	public String getSslProxyPort() {
		return sslProxyPort;
	}

	private StringBuffer getPrefsContent(String prefsPath) {

		InputStreamReader inputReader = null;
		File file = null;
		StringBuffer inputFileContents = new StringBuffer();
		char[] inputBuf = new char[1000];
		int bytesRead = 0;
		try {
			file = new File(prefsPath);
			if (!file.exists()) {
				// bugzilla 105953
				setAdapterProblem(true);
				setAdapterError(PREFS_NOT_FOUND);
				return null;
			}

			inputReader = new InputStreamReader(new FileInputStream(file));
			bytesRead = inputReader.read(inputBuf);

			while (bytesRead != -1) {
				inputFileContents.append(inputBuf, 0, bytesRead);
				bytesRead = inputReader.read(inputBuf);
			}
			inputReader.close();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (inputReader != null)
				try {
					inputReader.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
		}
		return inputFileContents;
	}

	public FirefoxPrefs (FirefoxPrefs myMozDefaultPrefs, FirefoxPrefs myMozUserPrefs) {

		    setCurrentPrefs(myMozDefaultPrefs);

			if (myMozUserPrefs.foundHttpProxyType == true){
					proxyType = myMozUserPrefs.proxyType;
					isProxyEnabled = myMozUserPrefs.isProxyEnabled;
					isHttpProxyEnabled = myMozUserPrefs.isHttpProxyEnabled;
					
			}
			if (myMozUserPrefs.foundHttpProxyAddr == true){
				httpProxyAddr = myMozUserPrefs.httpProxyAddr;
			}
			
			if (myMozUserPrefs.foundHttpProxyPort == true){
				httpProxyPort = myMozUserPrefs.httpProxyPort;
			}
			if (myMozUserPrefs.isHttpProxyEnabled == true){
				isHttpProxyEnabled = myMozUserPrefs.isHttpProxyEnabled;
			}
			if (myMozUserPrefs.foundSocksVersion == true ){
				socksVersion = myMozUserPrefs.socksVersion;
			}
			if (myMozUserPrefs.foundHomePage == true ){
				homePage = myMozUserPrefs.homePage;
			}
			
			if (myMozUserPrefs.foundSslProxyAddr == true ){
				isSSLProxyEnabled = myMozUserPrefs.isSSLProxyEnabled;
				sslProxyAddr = myMozUserPrefs.sslProxyAddr;
			}
			
			if (myMozUserPrefs.foundSslProxyPort == true ){
				sslProxyPort = myMozUserPrefs.sslProxyPort;
			}
			if (myMozUserPrefs.foundSocksProxyPort == true ){
				socksProxyPort = myMozUserPrefs.socksProxyPort;
				isSocksProxyEnabled = myMozUserPrefs.isSocksProxyEnabled;
			}
			if (myMozUserPrefs.foundSocksProxyAddr == true ){
				socksProxyAddr = myMozUserPrefs.socksProxyAddr;
				isSocksProxyEnabled = myMozUserPrefs.isSocksProxyEnabled;
			}
			
			if (myMozUserPrefs.foundProxyOverrideAddr == true ){
				proxyOverrideAddr = myMozUserPrefs.proxyOverrideAddr;
				isProxyOverrideEnabled = myMozUserPrefs.isProxyOverrideEnabled;
			}
			
			if (myMozUserPrefs.foundAutoConfigURLEnabled == true ){
				autoConfigURLEnabledValue = myMozUserPrefs.autoConfigURLEnabledValue;
				isAutoConfigURLEnabled = myMozUserPrefs.isAutoConfigURLEnabled;
			}
			
			badProxySettings = myMozUserPrefs.badProxySettings;
			proxyError = myMozUserPrefs.proxyError;
			isBadProxyError = myMozUserPrefs.isBadProxyError;
	
	}

	private int isConfigValid() {
		// TODO Auto-generated method stub
		// MUST DO: SOCKS_SET
		// HTTP_PROXY_ONLY_SET
		// SECURE_PROXY_ONLY_SET
		// HTTP_SECURE_MISMATCH
		// HTTP_SECURE_LOCALHOST
		// AUTO_CONFIG_URL

		int validReturnCode = PROXY_SETTINGS_OK;

		boolean autoConfig = isAutoConfigURLEnabled();
		boolean socksProxy = isSocksProxyEnabled();
		boolean sslProxy = isSSLProxyEnabled();
		boolean httpProxy = isHttpProxyEnabled();
//		boolean proxyOverride = isProxyOverrideEnabled();
//		String httpProxyAddr = getHttpProxyAddr();
//		String sslProxyAddr = getSslProxyAddr();
//		String httpProxyPort = getHttpProxyPort();
//		String sslProxyPort = getSslProxyPort();

		if (autoConfig) {
			// AUTO_CONFIG_URLn or SOCKS_SET
			validReturnCode = AUTO_CONFIG_URL;
			setBadProxySettings(true);
			setProxyError(validReturnCode);
		} else if (socksProxy) {
			validReturnCode = SOCKS_SET;
			setBadProxySettings(true);
			setProxyError(validReturnCode);
		} else if (sslProxy && !httpProxy) {
			validReturnCode = SECURE_PROXY_ONLY_SET;
			setBadProxySettings(true);
			setProxyError(validReturnCode);
		} else if (httpProxy && !sslProxy) {
			validReturnCode = HTTP_PROXY_ONLY_SET;
			setBadProxySettings(true);
			setProxyError(validReturnCode);
		} else if ((httpProxy) && (sslProxy)) {
			// HTTP_SECURE_MISMATCH
			validReturnCode = PROXY_SETTINGS_OK;
		}

		return validReturnCode;
	}

	/**
	 * @param badProxySettings
	 *            The badProxySettings to set.
	 */
	public void setBadProxySettings(boolean badProxySettings) {
		this.badProxySettings = badProxySettings;
	}

	/**
	 * @param proxyError
	 *            The proxyError to set.
	 */
	public void setProxyError(int proxyError) {
		this.proxyError = proxyError;
	}

	public StringBuffer generateNewPrefsBuffer() {
		// # Firefox User Preferences
		//
		// /* Do not edit this file.
		// *
		// * If you make changes to this file while the browser is running,
		// * the changes will be overwritten when the browser exits.
		// *
		// * To make a manual change to preferences, you can visit the URL
		// about:config
		// * For more information, see
		// http://www.firefox.org/unix/customizing.html#prefs
		// */
		// user_pref("browser.startup.homepage", "http://w3.ibm.com");
		// user_pref("network.proxy.http", "mdunnlinux.rtp.raleigh.ibm.com");
		// user_pref("network.proxy.http_port", 3128);
		// user_pref("network.proxy.no_proxies_on", "");
		// user_pref("network.proxy.socks", "localhost");
		// user_pref("network.proxy.socks_port", 1080);
		// user_pref("network.proxy.socks_version", 4);

		StringBuffer returnedPrefs = new StringBuffer();
		// do prelim stuff
		String newLine = "";
		String thisProxyPort = "";
		Integer tempInt = null;
		if (listenPort <= 0){
			thisProxyPort = "1080";
		}
		else {
			tempInt = new Integer(listenPort);
			thisProxyPort = tempInt.toString();
		}

		newLine = "\r\n\r\n";
		returnedPrefs.append(newLine);
		newLine = FIND_NETWORK_PROXY_TYPE + "1);\r\n";
		returnedPrefs.append(newLine);
		if (!isProxyEnabled) {
			// newLine = FIND_SOCKS_PROXY + "\"localhost\");\r\n";
			// bugzilla 165310 
			newLine = FIND_SOCKS_PROXY + "\"127.0.0.1\");\r\n";
			returnedPrefs.append(newLine);
			newLine = FIND_SOCKS_PROXY_PORT + thisProxyPort + ");\r\n";
			returnedPrefs.append(newLine);
		}
		newLine = FIND_SOCKS_VERSION + "4);\r\n";
		returnedPrefs.append(newLine);
		newLine = FIND_PROXY_OVERRIDE + " \"\");\r\n";
		returnedPrefs.append(newLine);
		// remove network proxy, if any
		if (isHttpProxyEnabled) {
			// bugzilla 165310 mdd 1/9/2007
			// newLine = FIND_HTTP_PROXY + "\"localhost\");\r\n";
			newLine = FIND_HTTP_PROXY + "\"127.0.0.1\");\r\n";
			returnedPrefs.append(newLine);
			newLine = FIND_HTTP_PROXY_PORT + thisProxyPort +");\r\n";
			returnedPrefs.append(newLine);
		} else {
			newLine = FIND_HTTP_PROXY + " \"\");\r\n";
			returnedPrefs.append(newLine);
			newLine = FIND_HTTP_PROXY_PORT + "0" +");\r\n";
			returnedPrefs.append(newLine);
		}
		if (isSSLProxyEnabled) {
			// bugzilla 165310 mdd 1/9/2007
			// newLine = FIND_SSL_PROXY + "\"localhost\");\r\n";
			newLine = FIND_SSL_PROXY + "\"127.0.0.1\");\r\n";
			returnedPrefs.append(newLine);
			newLine = FIND_SSL_PROXY_PORT + thisProxyPort +");\r\n";
			returnedPrefs.append(newLine);
		} else {
			newLine = FIND_SSL_PROXY + " \"\");\r\n";
			returnedPrefs.append(newLine);
			newLine = FIND_SSL_PROXY_PORT + "0" +");\r\n";
			returnedPrefs.append(newLine);
		}

		return returnedPrefs;
	}
	private String getUserPrefsPath() {
		String userPrefsPath = "";
		// bugzilla 177340  mdd 04/27/2007  change how we do this
		userPrefsPath=firefoxPrefsBasePath + "user.js";
		return userPrefsPath;
	}

	private String getDefaultPrefsPath() {
		String defaultPrefsPath = "";
		currentOS = Platform.getOS();
		userHome = System.getProperty("user.home");
		userName = System.getProperty("user.name");

		String profilesIniPath = "";
		profilesIniPath = findIniPath();
		
		// bugzilla 177340 mdd 4/27/2007
		profilesIniPath = profilesIniPath + "profiles.ini";
		defaultPrefsPath = scanProfilesIniForPrefs(profilesIniPath);

		firefoxPrefsBasePath = defaultPrefsPath;
		defaultPrefsPath += "prefs.js";
		firefoxDefaultPrefsPathDir = firefoxPrefsBasePath;
		firefoxUserPrefsPathDir = firefoxPrefsBasePath;
		return defaultPrefsPath;
	}
	
	private String findIniPath() {
		String iniPath = "";
		
		if (currentOS.equals("linux")) {
			iniPath = userHome + "/.mozilla/" + "firefox" + "/";
			separatorChar = "/";
		} else if (currentOS.equals("win32")) {
			iniPath = userHome
					+ "\\Application Data\\Mozilla\\Firefox\\";
			separatorChar = "\\";
		}
		return iniPath;
	}

	private String scanProfilesIniForPrefs(String profilesIniPath) {
		String returnedDefaultPrefsPath = "";
		StringBuffer profilesContent = null;
		
		File thisProfileDotIni = new File(profilesIniPath);
		if (thisProfileDotIni != null  && thisProfileDotIni.exists()) {
			profilesContent = getRecFileContent(profilesIniPath);
			if (profilesContent != null && profilesContent.length() > 0){
				returnedDefaultPrefsPath = scanProilesIni(profilesContent);
			}
		}
	
		return returnedDefaultPrefsPath;
	}
	private String scanProilesIni(StringBuffer profilesContent) {
		// from above 		  
		//	PROFILES_INI_NAME = "Name=";
		//	PROFILES_INI_RELATIVE = "IsRelative=";
		//	PROFILES_INI_PATH = "Path=";
		//	PROFILES_INI_DEFAULT = "Default=1";
		//	PROFILES_INI_PROFILE = "[Profile";
  
		/*  Sample Profiles.ini File
			[General]
			StartWithLastProfile=1
			
			[Profile0]
			Name=default
			IsRelative=1
			Path=Profiles/a7b1q0cp.default
			
			[Profile1]
			Name=Mark's Super Profile 1
			IsRelative=1
			Path=Profiles/3to7txp0.Mark's Super Profile 1
			Default=1
			
			[Profile2]
			Name=Marks Other Profile In TMP
			IsRelative=0
			Path=D:\tmp\Marks Other Firefox Folder in TMP
		 */
		boolean defaultFlag = false;
		String prefsPath = "";
		String currentIsRelative="";
		String currentPath="";
		StringTokenizer fileTokenizer = new StringTokenizer(profilesContent.toString(), "\r\n");//$NON-NLS-1$
		while (fileTokenizer.hasMoreTokens()) {
			String line = fileTokenizer.nextToken();

			if (line.startsWith(PROFILES_INI_RELATIVE)){
				currentIsRelative=line.substring(PROFILES_INI_RELATIVE.length());
			}
			else if (line.startsWith(PROFILES_INI_PATH)){
				currentPath=line.substring(PROFILES_INI_PATH.length());
			}
			else if (line.startsWith(PROFILES_INI_DEFAULT)){
				defaultFlag = true;
			}
			else if (line.startsWith(PROFILES_INI_PROFILE)){
				if (defaultFlag == true) 
					break;
			}
			
		} // while more tokens 
		if (currentIsRelative.equals("1")){
			String convertSlashesPath = "";
			String iniPath = findIniPath();
			if (currentOS.equals("win32")) {
				convertSlashesPath = currentPath.replaceAll("/","\\\\");
				prefsPath = iniPath + convertSlashesPath;
			}
			else {
				prefsPath = iniPath + currentPath;
			}
		}
		// Path is Absolute, just copy it over
		else {
			prefsPath = currentPath;
		}
		if (currentOS.equals("win32")) {
			prefsPath += "\\";
		}
		else {
			prefsPath += "/";
		}
		return prefsPath;
	}

	private int createPrefsSettingsFile(StringBuffer newPrefsBuffer) {

		// this will do: 
		// rename user.js(firefoxUserPrefsPath)  to  firefoxUserPrefsPathDir + originalFirefoxUserPrefsFileName
		// rename prefs.js (firefoxDefaultPrefsPath) to: firefoxDefaultPrefsPathDir + originalFirefoxDefaultPrefsFileName
		// create new prefs - 
		// copy new prefs to user.js 
		
		int retcode = 0;
		File newFile = new File(firefoxUserPrefsPathDir + tempFirefoxUserPrefsFileName);
		// create new temp user.js file 
		//TODO after debugging, can rename the temp file to user.js instead of writing twice.
		try {
			OutputStreamWriter outputWriter = new OutputStreamWriter(
					new FileOutputStream(newFile));//$NON-NLS-1$
			outputWriter.write(newPrefsBuffer.toString());
			outputWriter.close();
		} catch (UnsupportedEncodingException e1) {
			e1.printStackTrace();
		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		 backupOriginalPrefs();
		File newUserFile = new File(firefoxUserPrefsPath);
		// create new user.js file 
		try {
			OutputStreamWriter outputWriter = new OutputStreamWriter(
					new FileOutputStream(newUserFile));//$NON-NLS-1$
			outputWriter.write(newPrefsBuffer.toString());
			outputWriter.close();
		} catch (UnsupportedEncodingException e1) {
			e1.printStackTrace();
		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		 newFile.delete();

		return retcode;
	}
	private int backupOriginalPrefs() {
		// backup up Firefox preferences files
		// rename user.js(firefoxUserPrefsPath)  to  firefoxUserPrefsPathDir + originalFirefoxUserPrefsFileName
		// rename prefs.js (firefoxDefaultPrefsPath) to: firefoxDefaultPrefsPathDir + originalFirefoxDefaultPrefsFileName
		int rc = 0;
		// Original Firefox User Prefs .../user.js
		File origUserPrefs = new File(firefoxUserPrefsPath);
		
		// User Prefs new name after backing it up ../OriginalFirefoxUserPrefs.js 
		File renamedUserPrefs = new File (firefoxUserPrefsPathDir + originalFirefoxUserPrefsFileName);
				
		//	Default Prefs new name after backing it up ../OriginalFirefoxDefaultPrefs.js
		File renamedDefaultPrefs = new File (firefoxDefaultPrefsPathDir + originalFirefoxDefaultPrefsFileName);
		
		// Delete the renamed User  prefs - if they exist 
		if (renamedUserPrefs.exists()){
			renamedUserPrefs.delete();
		}
		//	 Delete the renamed  Default prefs - if they exist 
		if (renamedDefaultPrefs.exists()){
			renamedDefaultPrefs.delete();
		}
		
		// if Original User Prefs exist - then rename to ../OriginalUserPrefs.js 
		if (origUserPrefs.exists()) {
			origUserPrefs.renameTo(renamedUserPrefs);
		}
		// note - Must COPY (NOT rename) the original prefs.js file to OriginalFirefoxDefaultPrefsFileName
		String toPrefsFile = firefoxDefaultPrefsPathDir + originalFirefoxDefaultPrefsFileName;
		copyPrefsFile(firefoxDefaultPrefsPath,toPrefsFile);
				
		return rc;
	}
	public int copyPrefsFile(String fromPrefsPath, String toPrefsPath){
		int rc = -1;
		StringBuffer originalDefaultPrefsContent = getPrefsContent(fromPrefsPath);
		File newUserFile = new File(toPrefsPath);
		// create new user.js file 
		try {
			OutputStreamWriter outputWriter = new OutputStreamWriter(
					new FileOutputStream(newUserFile));//$NON-NLS-1$
			outputWriter.write(originalDefaultPrefsContent.toString());
			outputWriter.close();
		} catch (UnsupportedEncodingException e1) {
			e1.printStackTrace();
		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		return rc;
	}
	public boolean isAdapterProblem() {
		return isAdapterProblem;
	}
	public void setAdapterProblem(boolean isAdapterProblem) {
		this.isAdapterProblem = isAdapterProblem;
	}
	public void setAdapterError(int adapterError) {
		this.adapterError = adapterError;
	}
	// bugzilla 105953
	private String findNewLaunchPath(String initInfo) {
		String returnedPath = "";
		String tmpPath = "";
		File recorder = null;
		determineRecorderPathFilePath(initInfo);
		if (RecorderPathFileStr != null && RecorderPathFileStr.length() > 0){
			tmpPath = getNewRecorderPath();
			if (tmpPath.length() > 0 ){
				recorder = new File(tmpPath);
				if (recorder.exists()){
					returnedPath = tmpPath;
				}
			}
		}
		
		return returnedPath;
	}

	private String getNewRecorderPath() {
		String newRecorderPath = "";
		StringBuffer recContent = null;
		File recFile = new File(RecorderPathFileStr);
		if (recFile.exists()){
			recContent = getRecFileContent(RecorderPathFileStr);
			String tmpPath = scanRecFileContent(recContent);
			if (tmpPath.length() > 0)
				newRecorderPath = tmpPath;
		}
		
		return newRecorderPath;
	}

	private void determineRecorderPathFilePath(String initInfo) {
		int iStartPos;
		int iEndPos;
		String strKeyFile = "";
		if ((initInfo == null) || (initInfo.length()<= 0)) {
			return;
		}
		iStartPos = initInfo.indexOf("sslkeyfile,");
		if (iStartPos >= 0){
			iStartPos = iStartPos + 11;
			iEndPos = initInfo.indexOf(";", iStartPos);
				if (iEndPos >= 0){
					strKeyFile = initInfo.substring(iStartPos, iEndPos );
			}
			else{
				strKeyFile = initInfo.substring(iStartPos);
			}
			// Now have a sslkeyfile, pull path out
			int lastSlash = strKeyFile.lastIndexOf(separatorChar);
			String tmp = strKeyFile.substring(0,lastSlash);
			RecorderPathFileStr = tmp + separatorChar + recorderPathFileName;
		}
		
	}
	public StringBuffer getRecFileContent(String recFilePath) {

		InputStreamReader inputReader = null;
		File file = null;
		StringBuffer inputFileContents = new StringBuffer();
		char[] inputBuf = new char[1000];
		int bytesRead = 0;
		try {
			file = new File(recFilePath);
			if (!file.exists()) {
				return null;
			}

			inputReader = new InputStreamReader(new FileInputStream(file));
			bytesRead = inputReader.read(inputBuf);

			while (bytesRead != -1) {
				inputFileContents.append(inputBuf, 0, bytesRead);
				bytesRead = inputReader.read(inputBuf);
			}
			inputReader.close();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (inputReader != null)
				try {
					inputReader.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
		}
		return inputFileContents;
	}
	public String scanRecFileContent(StringBuffer recFileContents) {
		// scan file
		String returnedPath = "";
		String tmpPath = "";
		String firefoxStr = "Firefox:";
		StringTokenizer fileTokenizer = new StringTokenizer(recFileContents.toString(), "\r\n");//$NON-NLS-1$
		while (fileTokenizer.hasMoreTokens()) {
			String line = fileTokenizer.nextToken();
			if (line.startsWith(firefoxStr)){
				tmpPath = line.substring(firefoxStr.length());
				tmpPath = tmpPath.trim();
				returnedPath = tmpPath;
				break;
			}
		}
		return returnedPath;
	}
	
	public String getDefaultApplicationPath() {
		// bugzilla 131548 mdd
		currentOS = Platform.getOS();
		
		if (currentOS.equals("win32")) {
			// bugzilla 133959 mdd make sure default it valid
			File browserApp = new File(WindowsLaunchPath);
			if (browserApp.exists())
				return WindowsLaunchPath;
			else
				return "";
		} else if (currentOS.equals("linux")) {
			// bugzilla 133959 mdd make sure default it valid
			File browserApp = new File(LinuxLaunchPath);
			if (browserApp.exists())
				return LinuxLaunchPath;
			else
				return "";
		}
		return null;
	}
	// bugzilla 133967
	private void checkAndFixAbortStatus() {
		// TODO Auto-generated method stub
		//  below - %prefspath%\FirefoxOriginalDefaultPrefs.js

		String backupDefaultPrefs = firefoxPrefsBasePath + originalFirefoxDefaultPrefsFileName;
		//	below -  %prefspath%\FirefoxOriginalUserPrefs.js
		String backupUserPrefs = firefoxPrefsBasePath + originalFirefoxUserPrefsFileName;
		File backupDefaultPrefsFile = new File(backupDefaultPrefs);
		File backupUserPrefsFile = new File(backupUserPrefs);
		File recorderDefaultPrefsPathFile = new File (firefoxDefaultPrefsPath);
		File recorderUserPrefsPathFile = new File (firefoxUserPrefsPath);
		
		// First, check prefs.js file
		if (backupDefaultPrefsFile.exists()) {
			// we have an abort - there is a FirefoxOriginalDefaultPrefs.js
			// Delete prefs.js, and rename FirefoxOriginalDefaultPrefs.js to prefs.js
			if (recorderDefaultPrefsPathFile.exists()){
				recorderDefaultPrefsPathFile.delete();
			}
			backupDefaultPrefsFile.renameTo(recorderDefaultPrefsPathFile);
			// next, check user.js file
			if (backupUserPrefsFile.exists()){
				// must delete user.js and rename FirefoxOriginalUserPrefs.js to user.js
				if (recorderUserPrefsPathFile.exists()){
					recorderUserPrefsPathFile.delete();
				}
				backupUserPrefsFile.renameTo(recorderUserPrefsPathFile);
			} else {
				// just delete user.js if it is there
				if (recorderUserPrefsPathFile.exists()){
					recorderUserPrefsPathFile.delete();
				}
			}
		}
	}
	
}
