/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRecorderApplicationAdapter.java,v 1.2 2005/10/27 19:31:34 jnevicos Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.local.appadapters;


/**
 * interface to be implemented by object which will provide the functionality of a Recorder Application Adapter
 * @author Ernest Jessee
 * @author jnevicos - refactored IRecorderApplicationAdapterClient into this interface
 */
public interface IRecorderApplicationAdapter
{
	public void init(String initInfo) throws RecorderApplicationAdapterException;
	public Process start() throws RecorderApplicationAdapterException;
	public void stop() throws RecorderApplicationAdapterException;
	public void cleanup() throws RecorderApplicationAdapterException;
	
	/**
	 * API for getting initialization info for the application adapter agent to use when starting the target application.
	 * This information can be anything as long as the adapter understand it.
	 * The adapter may have it's own preference page for acquiring this information from the user.  
	 * example:
	 * 	 port,450;host,localhost
	 * 
	 */
	public abstract String getInitString();
	
	/**
	 * API for setting initialization info for the application adapter.
	 * This information can be anything as long as the adapter understand it.
	 * The adapter may have it's own preference page for acquiring this information from the user.  
	 * example:
	 * 	 port,450;host,localhost
	 * 
	 */
	public abstract void setInitString(String initString);
	
	/**
	 * Method for returning the fully-qualified executable path to the application, or null if this is N/A 
	 * @return String
	 */
	public String getApplicationPath();

	/**
	 * Sets & stores the new application path.  Implementor is responsible for saving this data (via preferences)
	 * and ensuring that getApplicationPath() always returns this new data. 
	 *
	 */
	public void setApplicationPath(String path);
}
