/**********************************************************************
 * Copyright (c) 2007, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JNIWrapper.java,v 1.9 2010/02/22 18:48:29 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.recorder.local.appadapters;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import org.eclipse.hyades.test.core.TestCorePlugin;

/**
 * <p>JNI wrapper around the <code>TPTPRecUtil.dll</code> library.</p>
 *
 * 
 * @author      Paul E. Slauenwhite
 * @author      Duwayne Morris
 * @version     February 22, 2010
 * @since       October 23, 2007
 * @see         TestCorePlugin#getRecordingUtilityLibraryPath()
 * @deprecated  This is internal API.
 */
public class JNIWrapper {
	
	private static final native String getLastError();
	private static final native String getIEAppPath();
	private static final native String getEnableJavaConsole();
	private static final native String getIEConnectionsSetting(String name);
	private static final native String getIESetting(String name);
	private static final native int setIEConnectionsSetting(String name, String value);
	private static final native int setIESetting(String name, String value, int type);
	private static final native int launchIE(String url);
	private static final native int waitForIEProcess();
	private static final native int killIEProcess();
	private static final native int isProcessElevated();
	private static final native int lookForNewBrowser();
	private static final native int isIERunning();
	
	public static final int REG_SZ = 1;
	public static final int REG_DWORD = 4;
	
	public static String pluginPath;
	public static String blankURL = null;

	static {

		//Attempt to resolve the org.eclipse.hyades.test.core plug-in path:
		pluginPath = TestCorePlugin.getDefault().getPluginPath();
		
		//Attempt to load the TPTPRecUtil.dll library:
		String recordingUtilityLibraryPath = TestCorePlugin.getDefault().getRecordingUtilityLibraryPath();
		
		if(recordingUtilityLibraryPath != null){
			System.load(recordingUtilityLibraryPath);
		}
	}

	public synchronized String getIEPath(){
		
		String path = getIEAppPath();
		return path;
	}
	
	/**
	 * @deprecated As of TPTP 4.7.0, this method is no longer used.
	 */
	public synchronized String getEnableJava(){
		
		String path = getEnableJavaConsole();
		return path;
	}
	
	public synchronized String getInternetConnectionsSetting(String name){
		return (getIEConnectionsSetting(name));
	}

	public synchronized String getInternetSetting(String name){
		return (getIESetting(name));
	}
	
	public synchronized boolean setInternetConnectionsSetting(String name, String value){		
		return (setIEConnectionsSetting(name, value) > 0);
	}
	
	public synchronized boolean setInternetSetting(String name, String value){
		int i = 0;
	
		if (value.startsWith("dword:", 0)){
			int index = value.indexOf(":");
			index++;
			value = value.substring(index);
			value = value.trim();
			Integer intVal = new Integer(value);
			value = intVal.toString();
			i = setIESetting(name, value, REG_DWORD);
			
			
		}else{
			i = setIESetting(name, value, REG_SZ);
		}
		if (i > 0)
			return true;
		else
			return false;
	}
	
	/**
	 * @deprecated As of TPTP 4.7.0, this method is no longer used.
	 */
	public synchronized String getErrorMessage(){
		String errorMsg = getLastError();
		System.out.println(errorMsg);
		return errorMsg;
		
	}

	public boolean startIE(String url){
		int retCode = 0;
		// we create a temporary blank.html file on the fly
		// using IELaunchURL with about:blank fails and we generally 
		// want a blank page to come up so the users default URL page won't end up
		// being a part of every recording
		if (url.compareTo("about:blank") == 0){
			blankURL = null;
			try {
				File tfile = File.createTempFile("blank", ".html");

				//Request for the file to be deleted when the JVM exits:
				tfile.deleteOnExit();
				
				blankURL = tfile.getPath();
				if (!tfile.exists()){
						tfile.createNewFile();
					OutputStreamWriter outputWriter = 
						new OutputStreamWriter(new FileOutputStream(tfile),"UnicodeLittle");//$NON-NLS-1$
					outputWriter.write("<HTML></HTML>");//$NON-NLS-1$
					outputWriter.close();
				}
			}
			catch (IOException e){
				// we will just launch IE with the user default page if there is an exception creating
				// the temp file. 
			}
			
			//blankURL = pluginPath + "blank.htm";
			retCode = launchIE(blankURL);
		}else{
			retCode = launchIE(url);
		}

		if (retCode == 0)
			return false;
		else
			return true;
	}
	
	public boolean waitForIE(){
		int retCode = 0;

		retCode = waitForIEProcess();
		if (blankURL != null){
			File tfile = new File(blankURL);
			if (tfile.exists())
				tfile.delete();
		}
		if (retCode == 0)
			return false;
		else
			return true;
		
	}
	
	public boolean terminateIE(){
		int retCode = 0;

		retCode = killIEProcess();
		if (retCode == 0)
			return false;
		else
			return true;
		
	}
	
	public boolean isProcessRunningElevated(){
		int i = isProcessElevated();
		if (i == 0)
			return false;
		else
			return true;
	}
	
	public void clientConnectNotification(){
		lookForNewBrowser();
	}
	
	public boolean isBrowserRunning(){
		int i = isIERunning();
		if (i == 0)
			return false;
		else
			return true;
	}
}


