/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MozillaPrefs.java,v 1.17 2010/02/22 16:00:05 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.local.appadapters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.core.TestCorePlugin;

/**
 * This object is the support methods for the MozillaAdapter.  In particular, this
 * object is able to read and modify user preference settings to cause Firefox to use a
 * particular host and port for proxy recording.
 * <p/>
 * 
 * 
 * @author  Mark D Dunn
 * @author  Paul E. Slauenwhite
 * @version February 22, 2010
 * @since   May 25, 2005
 * @deprecated  This is internal API.
 */

public class MozillaPrefs {
	// scan file
	// user_pref("network.proxy.http", "CleteDunn");
	// user_pref("network.proxy.no_proxies_on", "");
	// user_pref("network.proxy.socks", "127.0.0.1");
	// user_pref("network.proxy.socks_port", 1080);
	// user_pref("network.proxy.socks_version", 4);
	// user_pref("network.proxy.type", 1);
	// user_pref("browser.startup.homepage", "http://w3.ibm.com");

	final String FIND_HTTP_PROXY = "user_pref(\"network.proxy.http\",";
	final String FIND_HTTP_PROXY_PORT = "user_pref(\"network.proxy.http_port\",";
	final String FIND_PROXY_OVERRIDE = "user_pref(\"network.proxy.no_proxies_on\",";
	final String FIND_SOCKS_PROXY = "user_pref(\"network.proxy.socks\",";
	final String FIND_SOCKS_PROXY_PORT = "user_pref(\"network.proxy.socks_port\",";
	final String FIND_SOCKS_VERSION = "user_pref(\"network.proxy.socks_version\",";
	final String FIND_HOMEPAGE = "user_pref(\"browser.startup.homepage\",";
	final String FIND_SSL_PROXY = "user_pref(\"network.proxy.ssl\",";
	final String FIND_SSL_PROXY_PORT = "user_pref(\"network.proxy.ssl_port\",";
	final String FIND_AUTO_CONFIG_URL = "user_pref(\"network.proxy.autoconfig_url\",";
	final String FIND_NETWORK_PROXY_TYPE = "user_pref(\"network.proxy.type\",";
	final String FIND_NETWORK_HTTP_PROXY_SSL = "user_pref(\"network.http.proxy.ssl\",";
	// network.proxy.type: 0 - Unused/Unset 1 -Manual 2-Automatic 3-None
	private String proxyType = "";
	private String httpProxyAddr = "";
	private String httpProxyPort = "";
	private boolean isHttpProxyEnabled = false;
	private boolean badProxySettings = false;
	private boolean isAdapterProblem = false;
	private int proxyError = -1;
	private boolean isAutoConfigURLEnabled = false;
	private boolean isProxyOverrideEnabled = false;
	private String autoConfigURLEnabledValue = "";
	private String homePage = "";
	private String socksVersion = "";
	private boolean isSocksProxyEnabled = false;
	private String socksProxyAddr = "";
	private String socksProxyPort = "";
	private String proxyOverrideAddr = "";
	public final int PROXY_SETTINGS_OK = 0;
	public final int SOCKS_SET = -1;
	public final int HTTP_PROXY_ONLY_SET = -2;
	public final int SECURE_PROXY_ONLY_SET = -3;
	public final int HTTP_SECURE_MISMATCH = -4;
	public final int HTTP_SECURE_LOCALHOST = -5;
	public final int HTTP_PROXY_OVERRIDE = -6;
	public final int AUTO_CONFIG_URL = -7;
	// bugzilla 105953
	public final int PREFS_NOT_FOUND = -8;
	//	bugzilla 106791
	public final int BROWSER_NOT_FOUND = -9;

	// bugzilla 79219 mdd
	private String sslProxyAddr = "";
	private String sslProxyPort = "";
	private boolean isSSLProxyEnabled = false;
	private String startupURL = "about:blank";
	private String WindowsLaunchPath = "C:\\Program Files\\mozilla.org\\Mozilla\\mozilla.exe";
	private String LinuxLaunchPath = "/usr/bin/mozilla";
	private String launchPath = "";
	private String originalMozillaDefaultPrefsFileName = "MozillaOriginalDefaultPrefs.js";//$NON-NLS-1$
	private String originalMozillaUserPrefsFileName = "MozillaOriginalUserPrefs.js";//$NON-NLS-1$
	private String tempMozillaUserPrefsFileName = "tempMozillaUserPrefs.js";//$NON-NLS-1$
	// TODO defect 78895 below - also enable java console
	public String mozillaDefaultPrefsPath = "";
	public String mozillaUserPrefsPath = "";
	public String mozillaDefaultPrefsPathDir = "";
	public String mozillaUserPrefsPathDir = "";
	public String mozillaPrefsFilePath = "";
	private String userHome = "";
	private String userName = "";
	private String currentOS = "";
	private String separatorChar = "";
	boolean isProxyEnabled = false;
	private boolean isBadProxyError = false;
	// need these to reconcile User and Default prefs
	private boolean foundHttpProxyAddr = false;
	private boolean foundHttpProxyPort = false;
	private boolean foundProxyOverrideAddr = false;
	private boolean foundSocksProxyPort = false;
	private boolean foundSocksProxyAddr = false;
	private boolean foundSocksVersion = false;
	private boolean foundHomePage = false;
	private boolean foundSslProxyAddr = false;
	private boolean foundSslProxyPort = false;
	private boolean foundAutoConfigURLEnabled = false;
	private boolean foundHttpProxyType = false;
	private int listenPort = -1;
	private int adapterError = -1;
	private String sslKeyFilePath = "";
	private String RecorderPathFileStr = "";
	private String recorderPathFileName = "recorderPathFile";
	// bugzilla 131548 browser not found
	public static final String PREFERENCE_PATH = "RECORDER_MOZILLA_PATH";

	public MozillaPrefs() {
		init(false);
	}
	public MozillaPrefs(int proxyPort) {
		// bugzilla 131548
		boolean browserPathOK = false;
		listenPort = proxyPort;
		init(false);
		// bugzilla 121068 mdd
		if (!((badProxySettings == true) && (proxyError == this.PREFS_NOT_FOUND)))
			getPrefsToUse();
		// bugzilla 131548 browser not found
		browserPathOK = checkBrowserLaunchPath();
		if (!browserPathOK){
			setBadProxySettings(true);
			setProxyError(BROWSER_NOT_FOUND);
		}
	}
	public MozillaPrefs(int proxyPort, boolean checkAbortStatus) {
		// bugzilla 131548
		boolean browserPathOK = false;
		listenPort = proxyPort;
		init(checkAbortStatus);
		// bugzilla 121068 mdd
		if (!((badProxySettings == true) && (proxyError == this.PREFS_NOT_FOUND)))
			getPrefsToUse();
		// bugzilla 131548 browser not found
		browserPathOK = checkBrowserLaunchPath();
		if (!browserPathOK){
			setBadProxySettings(true);
			setProxyError(BROWSER_NOT_FOUND);
		}
	}
	public MozillaPrefs(int proxyPort, String sslKeyFilePath) {
		listenPort = proxyPort;
		init(false);

		getPrefsToUse(); 
		this.sslKeyFilePath = sslKeyFilePath;
		// bugzilla 105953
		checkLaunchPath();
	}

	private void checkLaunchPath() {
		String newLaunchPath = "";
		if ((sslKeyFilePath != null) && (sslKeyFilePath.length() <= 0)) {
			return;
		}
		currentOS = Platform.getOS();
		
		if (currentOS.equals("win32")) {
			separatorChar = "\\";
			launchPath = WindowsLaunchPath; 
		} else if (currentOS.equals("linux")) {
			separatorChar = "/";
		}
		newLaunchPath = findNewLaunchPath(sslKeyFilePath);
		if (newLaunchPath.length()>0) {
			launchPath = newLaunchPath;
		}
		File testBrowser = new File (launchPath);
		if (!testBrowser.exists()){
			setAdapterProblem(true);
			setAdapterError(BROWSER_NOT_FOUND);
		}
		
	}
	public MozillaPrefs(String thePrefsFilePath)  {
		mozillaPrefsFilePath = thePrefsFilePath;
		mozillaDefaultPrefsPath = getDefaultPrefsPath();
		if ((mozillaDefaultPrefsPath == ((String)null)) || mozillaDefaultPrefsPath.length() == 0) {
			setAdapterProblem(true);
			setAdapterError(PREFS_NOT_FOUND);
		}
		else {	
			mozillaUserPrefsPath = getUserPrefsPath();
			StringBuffer prefsContent = getPrefsContent(thePrefsFilePath);
			//	 bugzilla 105953
			if (prefsContent == null){
				setAdapterProblem(true);
				setAdapterError(PREFS_NOT_FOUND);
			}
			else {
				scanPrefsContent(prefsContent);
				isConfigValid();
			}
		}
	}

	public void scanPrefsContent(StringBuffer prefsFileContents) {
		// scan file
		// user_pref("network.proxy.http", "CleteDunn");
		// user_pref("network.proxy.no_proxies_on", "");
		// user_pref("network.proxy.socks", "127.0.0.1");
		// user_pref("network.proxy.socks_port", 1080);
		// user_pref("network.proxy.socks_version", 4);
		// user_pref("network.proxy.type", 1);
		StringTokenizer fileTokenizer = new StringTokenizer(prefsFileContents.toString(), "\r\n");//$NON-NLS-1$
		while (fileTokenizer.hasMoreTokens()) {
			String line = fileTokenizer.nextToken();
			String thisVal;
			if (line.startsWith(FIND_HTTP_PROXY)) {
				foundHttpProxyAddr = true;
				thisVal = getValue(line, FIND_HTTP_PROXY);
				if (thisVal.length() >= 1) {
					httpProxyAddr = thisVal;
					// isHttpProxyEnabled = true; look at network.proxy.type for this 
				}
			} else if (line.startsWith(FIND_HTTP_PROXY_PORT)) {
				thisVal = getValueNumber(line, FIND_HTTP_PROXY_PORT);
				foundHttpProxyPort = true;
				if (thisVal.length() >= 1) {
					httpProxyPort = thisVal;
				}
			} else if (line.startsWith(FIND_PROXY_OVERRIDE)) {
				foundProxyOverrideAddr = true;
				thisVal = getValue(line, FIND_PROXY_OVERRIDE);
				if (thisVal.length() >= 1) {
					proxyOverrideAddr = thisVal;
					isProxyOverrideEnabled = true;
				}
			} else if (line.startsWith(FIND_SOCKS_PROXY_PORT)) {
				foundSocksProxyPort = true;
				thisVal = getValueNumber(line, FIND_SOCKS_PROXY_PORT);
				if (thisVal.length() >= 1) {
					socksProxyPort = thisVal;
				}
			} else if (line.startsWith(FIND_SOCKS_PROXY)) {
				foundSocksProxyAddr = true;
				thisVal = getValue(line, FIND_SOCKS_PROXY);
				if (thisVal.length() >= 1) {
					socksProxyAddr = thisVal;
				}
			} else if (line.startsWith(FIND_SOCKS_VERSION)) {
				thisVal = getValueNumber(line, FIND_SOCKS_VERSION);
				foundSocksVersion = true;
				if (thisVal.length() >= 1) {
					socksVersion = thisVal;
				}
			} else if (line.startsWith(FIND_HOMEPAGE)) {
				foundHomePage = true;
				thisVal = getValue(line, FIND_HOMEPAGE);
				if (thisVal.length() >= 1) {
					homePage = thisVal;
				}
			} else if (line.startsWith(FIND_SSL_PROXY)) {
				foundSslProxyAddr=true;
				thisVal = getValue(line, FIND_SSL_PROXY);
				if (thisVal.length() >= 1) {
					sslProxyAddr = thisVal;
				}
			} else if (line.startsWith(FIND_SSL_PROXY_PORT)) {
				foundSslProxyPort = true;
				thisVal = getValueNumber(line, FIND_SSL_PROXY_PORT);
				// TODO check thisVal see if nUll before doing anything
				if (thisVal.length() >= 1) {
					sslProxyPort = thisVal;
				}

			} else if (line.startsWith(FIND_AUTO_CONFIG_URL)) {
				thisVal = getValue(line, FIND_AUTO_CONFIG_URL);
				isAutoConfigURLEnabled = true;
				autoConfigURLEnabledValue = thisVal;
				foundAutoConfigURLEnabled = true;
			} else if (line.startsWith(FIND_NETWORK_PROXY_TYPE)) {
				thisVal = getValueNumber(line, FIND_NETWORK_PROXY_TYPE);
				proxyType = thisVal;
				foundHttpProxyType = true;
				if (proxyType.equals("1")) {
					isProxyEnabled = true;
				}
			}
		}
		// Now determine if http and ssl proxies are enabled 
		if (isProxyEnabled){
			if ( (httpProxyAddr.length() > 0 ) && (httpProxyPort.length() > 0)){
				isHttpProxyEnabled = true;
			}
			if ( (sslProxyAddr.length() > 0 ) && (sslProxyPort.length() > 0)){
				isSSLProxyEnabled = true;
			}
			if ( (socksProxyAddr.length() > 0 ) && (socksProxyPort.length() > 0)){
				isSocksProxyEnabled = true;
			}
		}
	}
	// return a copy of the prefs sent in
	public MozillaPrefs(MozillaPrefs originalPrefs) {
		proxyType = originalPrefs.proxyType;
		httpProxyAddr = originalPrefs.httpProxyAddr;
		httpProxyPort = originalPrefs.httpProxyPort;
		isHttpProxyEnabled = originalPrefs.isHttpProxyEnabled;
		badProxySettings = originalPrefs.badProxySettings;
		proxyError = originalPrefs.proxyError;
		isAutoConfigURLEnabled = originalPrefs.isAutoConfigURLEnabled;
		isProxyOverrideEnabled = originalPrefs.isProxyOverrideEnabled;
		autoConfigURLEnabledValue = originalPrefs.autoConfigURLEnabledValue;
		homePage = originalPrefs.homePage;
		socksVersion = originalPrefs.socksVersion;
		isSocksProxyEnabled = originalPrefs.isSocksProxyEnabled;
		socksProxyAddr = originalPrefs.socksProxyAddr;
		socksProxyPort = originalPrefs.socksProxyPort;
		proxyOverrideAddr = originalPrefs.proxyOverrideAddr;
		sslProxyAddr = originalPrefs.sslProxyAddr;
		sslProxyPort = originalPrefs.sslProxyPort;
		isSSLProxyEnabled = originalPrefs.isSSLProxyEnabled;
		startupURL = originalPrefs.startupURL;
		WindowsLaunchPath = originalPrefs.WindowsLaunchPath;
		LinuxLaunchPath = originalPrefs.LinuxLaunchPath;
		launchPath = originalPrefs.launchPath;
		// TODO defect 78895 below - also enable java console
		mozillaDefaultPrefsPath = originalPrefs.mozillaDefaultPrefsPath;
		mozillaUserPrefsPath = originalPrefs.mozillaUserPrefsPath;
		mozillaDefaultPrefsPathDir = originalPrefs.mozillaDefaultPrefsPathDir;
		mozillaUserPrefsPathDir = originalPrefs.mozillaUserPrefsPathDir;
		mozillaPrefsFilePath = originalPrefs.mozillaPrefsFilePath;
		userHome = originalPrefs.userHome;
		userName = originalPrefs.userName;
		currentOS = originalPrefs.currentOS;
		separatorChar = originalPrefs.separatorChar;
		isProxyEnabled = originalPrefs.isProxyEnabled;
		isBadProxyError = originalPrefs.isBadProxyError;
		foundHttpProxyAddr = originalPrefs.foundHttpProxyAddr;
		foundHttpProxyPort = originalPrefs.foundHttpProxyPort;
		foundProxyOverrideAddr = originalPrefs.foundProxyOverrideAddr;
		foundSocksProxyPort = originalPrefs.foundSocksProxyPort;
		foundSocksProxyAddr = originalPrefs.foundSocksProxyAddr;
		foundSocksVersion = originalPrefs.foundSocksVersion;
		foundHomePage = originalPrefs.foundHomePage;
		foundSslProxyAddr = originalPrefs.foundSslProxyAddr;
		foundSslProxyPort = originalPrefs.foundSslProxyPort;
		foundAutoConfigURLEnabled = originalPrefs.foundAutoConfigURLEnabled;
		foundHttpProxyType = originalPrefs.foundHttpProxyType;
		listenPort = originalPrefs.listenPort;
		sslKeyFilePath = originalPrefs.sslKeyFilePath;

	}
	// set current prefs to the prefs sent in
	public void setCurrentPrefs(MozillaPrefs newPrefs) {
		if (newPrefs != null) {
			proxyType = newPrefs.proxyType;
			httpProxyAddr = newPrefs.httpProxyAddr;
			httpProxyPort = newPrefs.httpProxyPort;
			isHttpProxyEnabled = newPrefs.isHttpProxyEnabled;
			badProxySettings = newPrefs.badProxySettings;
			proxyError = newPrefs.proxyError;
			isAutoConfigURLEnabled = newPrefs.isAutoConfigURLEnabled;
			isProxyOverrideEnabled = newPrefs.isProxyOverrideEnabled;
			autoConfigURLEnabledValue = newPrefs.autoConfigURLEnabledValue;
			homePage = newPrefs.homePage;
			socksVersion = newPrefs.socksVersion;
			isSocksProxyEnabled = newPrefs.isSocksProxyEnabled;
			socksProxyAddr = newPrefs.socksProxyAddr;
			socksProxyPort = newPrefs.socksProxyPort;
			proxyOverrideAddr = newPrefs.proxyOverrideAddr;
			sslProxyAddr = newPrefs.sslProxyAddr;
			sslProxyPort = newPrefs.sslProxyPort;
			isSSLProxyEnabled = newPrefs.isSSLProxyEnabled;
			startupURL = newPrefs.startupURL;
			WindowsLaunchPath = newPrefs.WindowsLaunchPath;
			LinuxLaunchPath = newPrefs.LinuxLaunchPath;
			launchPath = newPrefs.launchPath;
			mozillaDefaultPrefsPath = newPrefs.mozillaDefaultPrefsPath;
			mozillaUserPrefsPath = newPrefs.mozillaUserPrefsPath;
			mozillaDefaultPrefsPathDir = newPrefs.mozillaDefaultPrefsPathDir;
			mozillaUserPrefsPathDir = newPrefs.mozillaUserPrefsPathDir;
			mozillaPrefsFilePath = newPrefs.mozillaPrefsFilePath;
			userHome = newPrefs.userHome;
			userName = newPrefs.userName;
			currentOS = newPrefs.currentOS;
			separatorChar = newPrefs.separatorChar;
			isProxyEnabled = newPrefs.isProxyEnabled;
			isBadProxyError = newPrefs.isBadProxyError;
			foundHttpProxyAddr = newPrefs.foundHttpProxyAddr;
			foundHttpProxyPort = newPrefs.foundHttpProxyPort;
			foundProxyOverrideAddr = newPrefs.foundProxyOverrideAddr;
			foundSocksProxyPort = newPrefs.foundSocksProxyPort;
			foundSocksProxyAddr = newPrefs.foundSocksProxyAddr;
			foundSocksVersion = newPrefs.foundSocksVersion;
			foundHomePage = newPrefs.foundHomePage;
			foundSslProxyAddr = newPrefs.foundSslProxyAddr;
			foundSslProxyPort = newPrefs.foundSslProxyPort;
			foundAutoConfigURLEnabled = newPrefs.foundAutoConfigURLEnabled;
			foundHttpProxyType = newPrefs.foundHttpProxyType;
			listenPort = newPrefs.listenPort;
			sslKeyFilePath = newPrefs.sslKeyFilePath;
		}
	}
	public void init(boolean checkAbortFlag) {

		// TODO Determine launch path based on OS
//		File mozDefaultPrefsFile = null;
//		File mozUserPrefsFile = null;
//		MozillaPrefs myMozDefaultPrefs = null;
//		MozillaPrefs myMozUserPrefs = null;
//		MozillaPrefs prefsToUse = null; 
		
		currentOS = Platform.getOS();

		if (currentOS.equals("win32")) {
			separatorChar = "\\";
			launchPath = WindowsLaunchPath;
		} else if (currentOS.equals("linux")) {
			separatorChar = "/";
			launchPath = LinuxLaunchPath;
		}
		// TODO - find paths to Mozilla preferences files
		// Linux example - /home/mdunn/.mozilla/default/sb0nt166.slt/prefs.js
		// /home/mdunn/.mozilla/wx35y7kb.slt/prefs.js

		userHome = System.getProperty("user.home");
		userName = System.getProperty("user.name");
		// also sets mozillaxxxPrefsPathDir  
		mozillaDefaultPrefsPath = getDefaultPrefsPath();
		if ((mozillaDefaultPrefsPath == (String)null) ||(mozillaDefaultPrefsPath.length()== 0)) {
			this.proxyError = this.PREFS_NOT_FOUND;
			this.badProxySettings = true;
			setAdapterProblem(true);
		} 
		else {
			mozillaUserPrefsPath = getUserPrefsPath();
		}
		if (checkAbortFlag){
			checkAndFixAbortStatus();
		}
	}
	
	public MozillaPrefs getPrefsToUse(){
		MozillaPrefs usePrefs = null;
		File mozDefaultPrefsFile = null;
		File mozUserPrefsFile = null;
		MozillaPrefs myMozDefaultPrefs = null;
		MozillaPrefs myMozUserPrefs = null;
		MozillaPrefs prefsToUse = null; 
		
		mozDefaultPrefsFile = new File(mozillaDefaultPrefsPath);
		mozUserPrefsFile = new File(mozillaUserPrefsPath);
		if (mozDefaultPrefsFile.exists()){
			myMozDefaultPrefs = new MozillaPrefs(mozillaDefaultPrefsPath);
		}
		else {
			setAdapterProblem(true);
			setAdapterError(PREFS_NOT_FOUND);
		}
		if (mozUserPrefsFile.exists()){
			myMozUserPrefs = new MozillaPrefs(mozillaUserPrefsPath);
		}

		if ((myMozDefaultPrefs != null) && (myMozUserPrefs != null)) {
			// have them both, must reconcile
			prefsToUse = new MozillaPrefs (myMozDefaultPrefs, myMozUserPrefs);
		} else if (myMozDefaultPrefs != null) {
			prefsToUse = myMozDefaultPrefs;
		} else {
			prefsToUse = myMozUserPrefs;

		}	
		if (prefsToUse == null){
			prefsToUse = this;
		}
		setCurrentPrefs(prefsToUse);
		isConfigValid();
		StringBuffer newPrefsBuffer = null;
		boolean isProxyBad =  prefsToUse.isBadProxySettings();
		boolean isBrowserProblem =  prefsToUse.isAdapterProblem();
		if (!isProxyBad  && !isBrowserProblem) {
			newPrefsBuffer = generateNewPrefsBuffer();
			createPrefsSettingsFile(newPrefsBuffer);
		}
		usePrefs = prefsToUse;
		return usePrefs;
	}

	private String getValue(String thisLine, String thisKey) {
		String returnValue = "";
		String tmp = thisLine;
		int keyLen = thisKey.length();
		int thisLen = thisLine.length();
		if (keyLen > thisLen) {
			return null;
		}
		// first have "user_pref("network.proxy.http", "Clete Dunn");
		int nextPos = tmp.indexOf(thisKey);
		nextPos += keyLen;
		String tmp2 = tmp.substring(nextPos, thisLen);
		// now have "Clete Dunn");
		int firstQuote = tmp2.indexOf("\"");
		int secondQuote = tmp2.indexOf("\"", firstQuote + 1);
		String tmpVal = tmp2.substring(firstQuote + 1, secondQuote);
		returnValue = tmpVal;

		return returnValue;
	}

	private String getValueNumber(String thisLine, String thisKey) {
		String returnValue = "";
		String tmp = thisLine;
		int keyLen = thisKey.length();
		int thisLen = thisLine.length();
		if (keyLen > thisLen) {
			return null;
		}
		// first have "user_pref("network.proxy.http", "Clete Dunn");
		int nextPos = tmp.indexOf(thisKey);
		nextPos += keyLen;
		String tmp2 = tmp.substring(nextPos, thisLen);
		// now have " 1080);");
		tmp2 = tmp2.trim();
		int rightParen = tmp2.indexOf(")");

		String tmpVal = tmp2.substring(0, rightParen);
		returnValue = tmpVal;

		return returnValue;
	}

	public int getAUTO_CONFIG_URL() {
		return AUTO_CONFIG_URL;
	}

	public String getAutoConfigURLEnabledValue() {
		return autoConfigURLEnabledValue;
	}

	public boolean isBadProxySettings() {
		return badProxySettings;
	}

	public String getFIND_AUTO_CONFIG_URL() {
		return FIND_AUTO_CONFIG_URL;
	}

	public String getFIND_HOMEPAGE() {
		return FIND_HOMEPAGE;
	}

	public String getFIND_HTTP_PROXY() {
		return FIND_HTTP_PROXY;
	}

	public String getFIND_HTTP_PROXY_PORT() {
		return FIND_HTTP_PROXY_PORT;
	}

	public String getFIND_PROXY_OVERRIDE() {
		return FIND_PROXY_OVERRIDE;
	}

	public String getFIND_SOCKS_PROXY() {
		return FIND_SOCKS_PROXY;
	}

	public String getFIND_SOCKS_PROXY_PORT() {
		return FIND_SOCKS_PROXY_PORT;
	}

	public String getFIND_SOCKS_VERSION() {
		return FIND_SOCKS_VERSION;
	}

	public String getFIND_SSL_PROXY() {
		return FIND_SSL_PROXY;
	}

	public String getFIND_SSL_PROXY_PORT() {
		return FIND_SSL_PROXY_PORT;
	}

	public String getHomePage() {
		return homePage;
	}

	public int getHTTP_PROXY_ONLY_SET() {
		return HTTP_PROXY_ONLY_SET;
	}

	public int getHTTP_PROXY_OVERRIDE() {
		return HTTP_PROXY_OVERRIDE;
	}

	public int getHTTP_SECURE_LOCALHOST() {
		return HTTP_SECURE_LOCALHOST;
	}

	public int getHTTP_SECURE_MISMATCH() {
		return HTTP_SECURE_MISMATCH;
	}

	public String getHttpProxyAddr() {
		return httpProxyAddr;
	}

	public String getHttpProxyPort() {
		return httpProxyPort;
	}

	public boolean isAutoConfigURLEnabled() {
		return isAutoConfigURLEnabled;
	}

	public boolean isHttpProxyEnabled() {
		return isHttpProxyEnabled;
	}

	public boolean isProxyOverrideEnabled() {
		return isProxyOverrideEnabled;
	}

	public boolean isSocksProxyEnabled() {
		return isSocksProxyEnabled;
	}

	public boolean isSSLProxyEnabled() {
		return isSSLProxyEnabled;
	}

//	public int getPROXY_SETTINGS_OK() {
//		return PROXY_SETTINGS_OK;
//	}

	public int getProxyError() {
		return proxyError;
	}

	public int getAdapterError() {
		return adapterError;
	}
	
	public String getProxyOverrideAddr() {
		return proxyOverrideAddr;
	}

	public String getProxyType() {
		return proxyType;
	}

	public int getSECURE_PROXY_ONLY_SET() {
		return SECURE_PROXY_ONLY_SET;
	}

	public int getSOCKS_SET() {
		return SOCKS_SET;
	}

	public String getSocksProxyAddr() {
		return socksProxyAddr;
	}

	public String getSocksProxyPort() {
		return socksProxyPort;
	}

	public String getSocksVersion() {
		return socksVersion;
	}

	public String getSslProxyAddr() {
		return sslProxyAddr;
	}

	public String getSslProxyPort() {
		return sslProxyPort;
	}

	private StringBuffer getPrefsContent(String prefsPath) {
	
		InputStreamReader inputReader = null;
		File file = null;
		StringBuffer inputFileContents = new StringBuffer();
		char[] inputBuf = new char[1000];
		int bytesRead = 0;
		try {
			file = new File(prefsPath);
			if (!file.exists()) {
				// bugzilla 105953
				setAdapterProblem(true);
				setAdapterError(PREFS_NOT_FOUND);
				return null;
			}

			inputReader = new InputStreamReader(new FileInputStream(file));
			bytesRead = inputReader.read(inputBuf);

			while (bytesRead != -1) {
				inputFileContents.append(inputBuf, 0, bytesRead);
				bytesRead = inputReader.read(inputBuf);
			}
			inputReader.close();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (inputReader != null)
				try {
					inputReader.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
		}
		return inputFileContents;
	}


//	private boolean checkProxyEnabled(StringBuffer inputBuffer) {
//		boolean comparesOK = false;
//		StringTokenizer fileTokenizer = new StringTokenizer(inputBuffer
//				.toString(), "\r\n");//$NON-NLS-1$
//		while (fileTokenizer.hasMoreTokens()) {
//			String line = fileTokenizer.nextToken();
//			String newLine = line;
//			// example ProxyServer is key,
//			// "http=markdunn:1000;socks=localhost:450"
//			if (line.startsWith("\"ProxyEnable"))//$NON-NLS-1$
//			{
//				StringTokenizer lineTokenizer = new StringTokenizer(line, ":");//$NON-NLS-1$
//				newLine = lineTokenizer.nextToken(); // get ProxyEnable
//				newLine = lineTokenizer.nextToken();
//				if (newLine.equalsIgnoreCase("00000001"))
//					comparesOK = true;
//
//				break;
//			}
//		}
//		return comparesOK;
//	}
//
//	private String getProxyInfo(StringBuffer inputBuffer) {
//		boolean comparesOK = false;
//		String proxyString = "";
//		String httpString = "http=";
//		StringTokenizer fileTokenizer = new StringTokenizer(inputBuffer
//				.toString(), "\r\n");//$NON-NLS-1$
//		while (fileTokenizer.hasMoreTokens()) {
//			String line = fileTokenizer.nextToken();
//			String newLine = line;
//			// example ProxyServer is key,
//			// "http=markdunn:1000;socks=localhost:450"
//			if (line.startsWith("\"ProxyServer"))//$NON-NLS-1$
//			{
//				String tmp = "\"ProxyServer\"=";
//				String modifiedLine = line.substring(tmp.length());
//				String[] entireString = modifiedLine.split(";");
//				int numVars = entireString.length;
//				for (int i = 0; i < numVars; i++) {
//					String tmpEntireString = entireString[i].replaceAll("\"",
//							"");
//					int findIndex = tmpEntireString.indexOf(httpString);
//					if (findIndex != -1) {
//						// found the revisedString
//						String tmpVal = "";
//						tmpVal = tmpEntireString.substring(findIndex
//								+ httpString.length());
//						proxyString = tmpVal;
//					}
//				}
//			}
//		}
//		return proxyString;
//	}

	public MozillaPrefs (MozillaPrefs myMozDefaultPrefs, MozillaPrefs myMozUserPrefs) {

		    setCurrentPrefs(myMozDefaultPrefs);

			if (myMozUserPrefs.foundHttpProxyType == true){
					proxyType = myMozUserPrefs.proxyType;
					isProxyEnabled = myMozUserPrefs.isProxyEnabled;
					isHttpProxyEnabled = myMozUserPrefs.isHttpProxyEnabled;
					
			}
			if (myMozUserPrefs.foundHttpProxyAddr == true){
				httpProxyAddr = myMozUserPrefs.httpProxyAddr;
			}
			
			if (myMozUserPrefs.foundHttpProxyPort == true){
				httpProxyPort = myMozUserPrefs.httpProxyPort;
			}
			if (myMozUserPrefs.isHttpProxyEnabled == true){
				isHttpProxyEnabled = myMozUserPrefs.isHttpProxyEnabled;
			}
			if (myMozUserPrefs.foundSocksVersion == true ){
				socksVersion = myMozUserPrefs.socksVersion;
			}
			if (myMozUserPrefs.foundHomePage == true ){
				homePage = myMozUserPrefs.homePage;
			}
			
			if (myMozUserPrefs.foundSslProxyAddr == true ){
				isSSLProxyEnabled = myMozUserPrefs.isSSLProxyEnabled;
				sslProxyAddr = myMozUserPrefs.sslProxyAddr;
			}
			
			if (myMozUserPrefs.foundSslProxyPort == true ){
				sslProxyPort = myMozUserPrefs.sslProxyPort;
			}
			if (myMozUserPrefs.foundSocksProxyPort == true ){
				socksProxyPort = myMozUserPrefs.socksProxyPort;
				isSocksProxyEnabled = myMozUserPrefs.isSocksProxyEnabled;
			}
			if (myMozUserPrefs.foundSocksProxyAddr == true ){
				socksProxyAddr = myMozUserPrefs.socksProxyAddr;
				isSocksProxyEnabled = myMozUserPrefs.isSocksProxyEnabled;
			}
			
			if (myMozUserPrefs.foundProxyOverrideAddr == true ){
				proxyOverrideAddr = myMozUserPrefs.proxyOverrideAddr;
				isProxyOverrideEnabled = myMozUserPrefs.isProxyOverrideEnabled;
			}
			
			if (myMozUserPrefs.foundAutoConfigURLEnabled == true ){
				autoConfigURLEnabledValue = myMozUserPrefs.autoConfigURLEnabledValue;
				isAutoConfigURLEnabled = myMozUserPrefs.isAutoConfigURLEnabled;
			}
			
			badProxySettings = myMozUserPrefs.badProxySettings;
			proxyError = myMozUserPrefs.proxyError;
			isBadProxyError = myMozUserPrefs.isBadProxyError;
			
			// these won't change from preference to pref 
//			reconciledPrefs.startupURL = myMozUserPrefs.startupURL;
//			reconciledPrefs.WindowsLaunchPath = myMozUserPrefs.WindowsLaunchPath;
//			reconciledPrefs.LinuxLaunchPath = myMozUserPrefs.LinuxLaunchPath;
//			reconciledPrefs.launchPath = myMozUserPrefs.launchPath;
			// TODO defect 78895 below - also enable java console
//			reconciledPrefs.mozillaDefaultPrefsPath = myMozUserPrefs.mozillaDefaultPrefsPath;
//			reconciledPrefs.mozillaUserPrefsPath = myMozUserPrefs.mozillaUserPrefsPath;
			// this one is done above
			//reconciledPrefs.isProxyEnabled = myMozUserPrefs.isProxyEnabled;
		
	}

	private int isConfigValid() {
		// TODO Auto-generated method stub
		// MUST DO: SOCKS_SET
		// HTTP_PROXY_ONLY_SET
		// SECURE_PROXY_ONLY_SET
		// HTTP_SECURE_MISMATCH
		// HTTP_SECURE_LOCALHOST
		// AUTO_CONFIG_URL

		int validReturnCode = PROXY_SETTINGS_OK;

		boolean autoConfig = isAutoConfigURLEnabled();
		boolean socksProxy = isSocksProxyEnabled();
		boolean sslProxy = isSSLProxyEnabled();
		boolean httpProxy = isHttpProxyEnabled();
//		boolean proxyOverride = isProxyOverrideEnabled();
//		String httpProxyAddr = getHttpProxyAddr();
//		String sslProxyAddr = getSslProxyAddr();
//		String httpProxyPort = getHttpProxyPort();
//		String sslProxyPort = getSslProxyPort();

		if (autoConfig) {
			// AUTO_CONFIG_URLn or SOCKS_SET
			validReturnCode = AUTO_CONFIG_URL;
			setBadProxySettings(true);
			setProxyError(validReturnCode);
		} else if (socksProxy) {
			validReturnCode = SOCKS_SET;
			setBadProxySettings(true);
			setProxyError(validReturnCode);
		} else if (sslProxy && !httpProxy) {
			validReturnCode = SECURE_PROXY_ONLY_SET;
			setBadProxySettings(true);
			setProxyError(validReturnCode);
		} else if (httpProxy && !sslProxy) {
			validReturnCode = HTTP_PROXY_ONLY_SET;
			setBadProxySettings(true);
			setProxyError(validReturnCode);
		} else if ((httpProxy) && (sslProxy)) {
			// HTTP_SECURE_MISMATCH
			validReturnCode = PROXY_SETTINGS_OK;
		}

		return validReturnCode;
	}

	/**
	 * @param badProxySettings
	 *            The badProxySettings to set.
	 */
	public void setBadProxySettings(boolean badProxySettings) {
		this.badProxySettings = badProxySettings;
	}

	/**
	 * @param proxyError
	 *            The proxyError to set.
	 */
	public void setProxyError(int proxyError) {
		this.proxyError = proxyError;
	}

	public StringBuffer generateNewPrefsBuffer() {
		// # Mozilla User Preferences
		//
		// /* Do not edit this file.
		// *
		// * If you make changes to this file while the browser is running,
		// * the changes will be overwritten when the browser exits.
		// *
		// * To make a manual change to preferences, you can visit the URL
		// about:config
		// * For more information, see
		// http://www.mozilla.org/unix/customizing.html#prefs
		// */
		// user_pref("browser.startup.homepage", "http://w3.ibm.com");
		// user_pref("network.proxy.http", "mdunnlinux.rtp.raleigh.ibm.com");
		// user_pref("network.proxy.http_port", 3128);
		// user_pref("network.proxy.no_proxies_on", "");
		// user_pref("network.proxy.socks", "localhost");
		// user_pref("network.proxy.socks_port", 1080);
		// user_pref("network.proxy.socks_version", 4);

		StringBuffer returnedPrefs = new StringBuffer();
		// do prelim stuff
		String newLine = "";
		String thisProxyPort = "";
		Integer tempInt = null;
		if (listenPort <= 0){
			thisProxyPort = "1080";
		}
		else {
			tempInt = new Integer(listenPort);
			thisProxyPort = tempInt.toString();
		}

		newLine = "\r\n\r\n";
		returnedPrefs.append(newLine);
		newLine = FIND_NETWORK_PROXY_TYPE + "1);\r\n";
		returnedPrefs.append(newLine);
		if (!isProxyEnabled) {
			// bugzilla 165310 mdd 1/9/2007
			//newLine = FIND_SOCKS_PROXY + "\"localhost\");\r\n";
			newLine = FIND_SOCKS_PROXY + "\"127.0.0.1\");\r\n";
			returnedPrefs.append(newLine);
			newLine = FIND_SOCKS_PROXY_PORT + thisProxyPort + ");\r\n";
			returnedPrefs.append(newLine);
		}
		newLine = FIND_SOCKS_VERSION + "4);\r\n";
		returnedPrefs.append(newLine);
		newLine = FIND_PROXY_OVERRIDE + " \"\");\r\n";
		returnedPrefs.append(newLine);
		// remove network proxy, if any
		if (isHttpProxyEnabled) {
			//	bugzilla 165310 mdd 1/9/2007
			// newLine = FIND_HTTP_PROXY + "\"localhost\");\r\n";
			newLine = FIND_HTTP_PROXY + "\"127.0.0.1\");\r\n";
			returnedPrefs.append(newLine);
			newLine = FIND_HTTP_PROXY_PORT + thisProxyPort +");\r\n";
			returnedPrefs.append(newLine);
			
		} else {
			newLine = FIND_HTTP_PROXY + " \"\");\r\n";
			returnedPrefs.append(newLine);
			newLine = FIND_HTTP_PROXY_PORT + "0" +");\r\n";
			returnedPrefs.append(newLine);
		}
		if (isSSLProxyEnabled) {
			//	bugzilla 165310 mdd 1/9/2007
			// newLine = FIND_SSL_PROXY + "\"localhost\");\r\n";
			newLine = FIND_SSL_PROXY + "\"127.0.0.1\");\r\n";
			returnedPrefs.append(newLine);
			newLine = FIND_SSL_PROXY_PORT + thisProxyPort +");\r\n";
			returnedPrefs.append(newLine);
		} else {
			newLine = FIND_SSL_PROXY + " \"\");\r\n";
			returnedPrefs.append(newLine);
			newLine = FIND_SSL_PROXY_PORT + "0" +");\r\n";
			returnedPrefs.append(newLine);
		}

		return returnedPrefs;
	}
	private String getUserPrefsPath() {
		String userPrefsPath = "";
		userHome = System.getProperty("user.home");
		userName = System.getProperty("user.name");
		currentOS = Platform.getOS();
		if (currentOS.equals("linux")) {
			userPrefsPath = userHome + "/.mozilla/default/";
			separatorChar = "/";
		} else if (currentOS.equals("win32")) {
			userPrefsPath = userHome
					+ "\\Application Data\\Mozilla\\Profiles\\default\\";
			separatorChar = "\\";
		}
		File prefsRoot = new File(userPrefsPath);
		if (prefsRoot != null && prefsRoot.isDirectory()) {
			File thisSaltDir = findSaltDir(prefsRoot);
			mozillaUserPrefsPathDir = userPrefsPath + thisSaltDir.getName()	+ separatorChar;
			userPrefsPath = userPrefsPath + thisSaltDir.getName()
					+ separatorChar + "user.js";
		}

		return userPrefsPath;
	}

	private String getDefaultPrefsPath() {
		String defaultPrefsPath = "";
		currentOS = Platform.getOS();
		userHome = System.getProperty("user.home");
		userName = System.getProperty("user.name");
		
		if (currentOS.equals("linux")) {
			defaultPrefsPath = userHome + "/.mozilla/default/" ;
			separatorChar = "/";
		} else if (currentOS.equals("win32")) {
			defaultPrefsPath = userHome
					+ "\\Application Data\\Mozilla\\Profiles\\default\\";
			separatorChar = "\\";
		}
		File prefsRoot = new File(defaultPrefsPath);
		if (prefsRoot != null && prefsRoot.isDirectory()) {
			File thisSaltDir = findSaltDir(prefsRoot);
			if (thisSaltDir == (File)null) {
				return ((String)null);
			}
			mozillaDefaultPrefsPathDir = defaultPrefsPath + thisSaltDir.getName()
			+ separatorChar ;
			defaultPrefsPath = defaultPrefsPath + thisSaltDir.getName()
					+ separatorChar + "prefs.js";
		}

		return defaultPrefsPath;
	}
	
	private File findSaltDir(File prefsRoot) {
		File returnFile = null;
		String tmpSaltName = "";
		File[] allSalts = prefsRoot.listFiles();
		if (allSalts == null) {
			// no *.slt files found let it exit normally
		} else {
			for (int i = 0; i < allSalts.length; i++) {
				// this will get the last one on the list
				if (allSalts[i].getName().endsWith(".slt")) {
					if (allSalts[i].isDirectory()) {
						tmpSaltName = allSalts[i].getName();
					}
				}
			}
			if (tmpSaltName.length() > 0) {
				File saltDir = new File(tmpSaltName);
				returnFile = saltDir;
			}
		}
		return returnFile;
	}
	private int createPrefsSettingsFile(StringBuffer newPrefsBuffer) {

		// this will do: 
		// rename user.js(mozillaUserPrefsPath)  to  mozillaUserPrefsPathDir + originalMozillaUserPrefsFileName
		// rename prefs.js (mozillaDefaultPrefsPath) to: mozillaDefaultPrefsPathDir + originalMozillaDefaultPrefsFileName
		// create new prefs - 
		// copy new prefs to user.js 
		
		int retcode = 0;
		File newFile = new File(mozillaUserPrefsPathDir + tempMozillaUserPrefsFileName);
		// create new temp user.js file 
		//TODO after debugging, can rename the temp file to user.js instead of writing twice.
		try {
			OutputStreamWriter outputWriter = new OutputStreamWriter(
					new FileOutputStream(newFile));//$NON-NLS-1$
			outputWriter.write(newPrefsBuffer.toString());
			outputWriter.close();
		} catch (UnsupportedEncodingException e1) {
			e1.printStackTrace();
		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		 backupOriginalPrefs();
		File newUserFile = new File(mozillaUserPrefsPath);
		// create new user.js file 
		try {
			OutputStreamWriter outputWriter = new OutputStreamWriter(
					new FileOutputStream(newUserFile));//$NON-NLS-1$
			outputWriter.write(newPrefsBuffer.toString());
			outputWriter.close();
		} catch (UnsupportedEncodingException e1) {
			e1.printStackTrace();
		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		 newFile.delete();

		return retcode;
	}
	private int backupOriginalPrefs() {
		// backup up Mozilla preferences files
		// rename user.js(mozillaUserPrefsPath)  to  mozillaUserPrefsPathDir + originalMozillaUserPrefsFileName
		// rename prefs.js (mozillaDefaultPrefsPath) to: mozillaDefaultPrefsPathDir + originalMozillaDefaultPrefsFileName
		int rc = 0;
		// Original Mozilla User Prefs .../user.js
		File origUserPrefs = new File(mozillaUserPrefsPath);
		
		// User Prefs new name after backing it up ../OriginalMozillaUserPrefs.js 
		File renamedUserPrefs = new File (mozillaUserPrefsPathDir + originalMozillaUserPrefsFileName);
		
		//	Default Prefs new name after backing it up ../OriginalMozillaDefaultPrefs.js
		File renamedDefaultPrefs = new File (mozillaDefaultPrefsPathDir + originalMozillaDefaultPrefsFileName);
		
		// Delete the renamed User  prefs - if they exist 
		if (renamedUserPrefs.exists()){
			renamedUserPrefs.delete();
		}
		//	 Delete the renamed  Default prefs - if they exist 
		if (renamedDefaultPrefs.exists()){
			renamedDefaultPrefs.delete();
		}
		
		// if Original User Prefs exist - then rename to ../OriginalUserPrefs.js 
		if (origUserPrefs.exists()) {
			origUserPrefs.renameTo(renamedUserPrefs);
		}
		// note - Must COPY (NOT rename) the original prefs.js file to OriginalMozillaDefaultPrefsFileName
		String toPrefsFile = mozillaDefaultPrefsPathDir + originalMozillaDefaultPrefsFileName;
		copyPrefsFile(mozillaDefaultPrefsPath,toPrefsFile);
				
		return rc;
	}
	public int copyPrefsFile(String fromPrefsPath, String toPrefsPath){
		int rc = -1;
		StringBuffer originalDefaultPrefsContent = getPrefsContent(fromPrefsPath);
		File newUserFile = new File(toPrefsPath);
		// create new user.js file 
		try {
			OutputStreamWriter outputWriter = new OutputStreamWriter(
					new FileOutputStream(newUserFile));//$NON-NLS-1$
			outputWriter.write(originalDefaultPrefsContent.toString());
			outputWriter.close();
		} catch (UnsupportedEncodingException e1) {
			e1.printStackTrace();
		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		return rc;
	}
	public boolean isAdapterProblem() {
		return isAdapterProblem;
	}
	public void setAdapterProblem(boolean isAdapterProblem) {
		this.isAdapterProblem = isAdapterProblem;
	}
	public void setAdapterError(int adapterError) {
		this.adapterError = adapterError;
	}
	// bugzilla 105953
	private String findNewLaunchPath(String initInfo) {
		String returnedPath = "";
		String tmpPath = "";
		File recorder = null;
		determineRecorderPathFilePath(initInfo);
		if (RecorderPathFileStr != null && RecorderPathFileStr.length() > 0){
			tmpPath = getNewRecorderPath();
			if (tmpPath.length() > 0 ){
				recorder = new File(tmpPath);
				if (recorder.exists()){
					returnedPath = tmpPath;
				}
			}
		}
		
		return returnedPath;
	}

	private String getNewRecorderPath() {
		String newRecorderPath = "";
		StringBuffer recContent = null;
		File recFile = new File(RecorderPathFileStr);
		if (recFile.exists()){
			recContent = getRecFileContent(RecorderPathFileStr);
			String tmpPath = scanRecFileContent(recContent);
			if (tmpPath.length() > 0)
				newRecorderPath = tmpPath;
		}
		
		return newRecorderPath;
	}

	private void determineRecorderPathFilePath(String initInfo) {
		int iStartPos;
		int iEndPos;
		String strKeyFile = "";
		if ((initInfo == null) || (initInfo.length()<= 0)) {
			return;
		}
		iStartPos = initInfo.indexOf("sslkeyfile,");
		if (iStartPos >= 0){
			iStartPos = iStartPos + 11;
			iEndPos = initInfo.indexOf(";", iStartPos);
				if (iEndPos >= 0){
					strKeyFile = initInfo.substring(iStartPos, iEndPos );
			}
			else{
				strKeyFile = initInfo.substring(iStartPos);
			}
			// Now have a sslkeyfile, pull path out
			int lastSlash = strKeyFile.lastIndexOf(separatorChar);
			String tmp = strKeyFile.substring(0,lastSlash);
			RecorderPathFileStr = tmp + separatorChar + recorderPathFileName;
		}
		
	}
	public StringBuffer getRecFileContent(String recFilePath) {

		InputStreamReader inputReader = null;
		File file = null;
		StringBuffer inputFileContents = new StringBuffer();
		char[] inputBuf = new char[1000];
		int bytesRead = 0;
		try {
			file = new File(recFilePath);
			if (!file.exists()) {
				return null;
			}

			inputReader = new InputStreamReader(new FileInputStream(file));
			bytesRead = inputReader.read(inputBuf);

			while (bytesRead != -1) {
				inputFileContents.append(inputBuf, 0, bytesRead);
				bytesRead = inputReader.read(inputBuf);
			}
			inputReader.close();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (inputReader != null)
				try {
					inputReader.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
		}
		return inputFileContents;
	}
	public String scanRecFileContent(StringBuffer recFileContents) {
		// scan file
		String returnedPath = "";
		String tmpPath = "";
		String firefoxStr = "Mozilla:";
		StringTokenizer fileTokenizer = new StringTokenizer(recFileContents.toString(), "\r\n");//$NON-NLS-1$
		while (fileTokenizer.hasMoreTokens()) {
			String line = fileTokenizer.nextToken();
			if (line.startsWith(firefoxStr)){
				tmpPath = line.substring(firefoxStr.length());
				tmpPath = tmpPath.trim();
				returnedPath = tmpPath;
				break;
			}
		}
		return returnedPath;
	}
	private boolean checkBrowserLaunchPath() {
		// bugzilla 131548 browser not found
		File testBrowser = new File (getApplicationPath());
		if (!testBrowser.exists()){
			return false;
		}
		return true;
	}
	public String getApplicationPath() {
		//	 bugzilla 131548 browser not found
		String str = TestCorePlugin.getDefault().getPluginPreferences().getString(PREFERENCE_PATH);
		if (str == null || str.length() == 0)
			return getDefaultApplicationPath();
		else 
			return str;
	}
	public String getDefaultApplicationPath() {
		// bugzilla 131548 mdd
		currentOS = Platform.getOS();
		
		if (currentOS.equals("win32")) {
			// bugzilla 133959 mdd make sure default it valid
			File browserApp = new File(WindowsLaunchPath);
			if (browserApp.exists())
				return WindowsLaunchPath;
			else 
				return "";
		} else if (currentOS.equals("linux")) {
			// bugzilla 133959 mdd 
			File browserApp = new File(LinuxLaunchPath);
			if (browserApp.exists())
				return LinuxLaunchPath;
			else 
				return "";
		}
		return null;
	}
	private void checkAndFixAbortStatus() {
		// TODO Auto-generated method stub
		//  below - %prefspath%\FirefoxOriginalDefaultPrefs.js

		String backupDefaultPrefs = mozillaDefaultPrefsPathDir + originalMozillaDefaultPrefsFileName;
		//	below -  %prefspath%\FirefoxOriginalUserPrefs.js
		String backupUserPrefs = mozillaDefaultPrefsPathDir + originalMozillaUserPrefsFileName;
		File backupDefaultPrefsFile = new File(backupDefaultPrefs);
		File backupUserPrefsFile = new File(backupUserPrefs);
		File recorderDefaultPrefsPathFile = new File (mozillaDefaultPrefsPath);
		File recorderUserPrefsPathFile = new File (mozillaUserPrefsPath);
		
		// First, check prefs.js file
		if (backupDefaultPrefsFile.exists()) {
			// we have an abort - there is a FirefoxOriginalDefaultPrefs.js
			// Delete prefs.js, and rename FirefoxOriginalDefaultPrefs.js to prefs.js
			if (recorderDefaultPrefsPathFile.exists()){
				recorderDefaultPrefsPathFile.delete();
			}
			backupDefaultPrefsFile.renameTo(recorderDefaultPrefsPathFile);
			// next, check user.js file
			if (backupUserPrefsFile.exists()){
				// must delete user.js and rename FirefoxOriginalUserPrefs.js to user.js
				if (recorderUserPrefsPathFile.exists()){
					recorderUserPrefsPathFile.delete();
				}
				backupUserPrefsFile.renameTo(recorderDefaultPrefsPathFile);
			} else {
				// just delete user.js if it is there
				if (recorderUserPrefsPathFile.exists()){
					recorderUserPrefsPathFile.delete();
				}
			}
		}
	}
	
}
