/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCorePreferences.java,v 1.7 2008/04/18 20:03:21 paules Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.test.core;

/**
 * Provides preferences constants for the plugin <code>org.eclipse.hyades.test.core</code>.
 * <p/>
 * These preferences are to be used as arguments of getters and setters of the class
 * returned by {@link org.eclipse.hyades.test.core.TestCorePlugin#getPluginPreferences()}.
 * These constants and services were previously in org.eclipse.hyades.test.ui.TestUi class.
 * <p/>
 * 
 * 
 * @author  Julien Canches
 * @author  Paul E. Slauenwhite
 * @version Arpril 18, 2008
 * @since   February 8, 2005
 */
public interface TestCorePreferences {

	/**
	 * Save interval preference name.
	 */
	public final static String SAVE_INTERVAL = "saveInterval";
	
	/**
	 * Default host name preference name.
	 * This defines the host name that is used by default when a new location is created.
	 */
	public static final String DEFAULT_HOST_NAME = "default_host_name";	

	/**
	 * Default port preference name.
	 * This defines the port that is used by default when a new location is created.
	 */
	public static final String DEFAULT_PORT = "default_port";

	/**
	 * Port of the local Agent Controller preference name.
	 * This is the port used by the Agent Controller on the local host.
	 * <p/>
	 * 
	 * @deprecated As of TPTP 4.5.0, use {@link DEFAULT_PORT}.
	 */
	public static final String LOCALHOST_PORT = DEFAULT_PORT;
}
