/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCorePreferencesInitializer.java,v 1.4 2008/04/18 20:14:30 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.internal;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.core.TestCorePreferences;

/**
 * This class implements the preferencesInitializer extension point for TestCore
 * preferences.
 * <p/>
 * 
 * 
 * @author  Julien Canches
 * @author  Paul E. Slauenwhite
 * @version April 18, 2008
 * @since   June 13, 2005
 * @see     org.eclipse.hyades.test.core.TestCorePreferences
 */
public class TestCorePreferencesInitializer extends	AbstractPreferenceInitializer {

	private void monitorPreferences()
	{
		Preferences.IPropertyChangeListener listener = new Preferences.IPropertyChangeListener()
		{
			public void propertyChange(Preferences.PropertyChangeEvent event)
			{
				if(TestCorePreferences.SAVE_INTERVAL.equals(event.getProperty()))
				{
					if(SaveManager.getInstance().isRunning())
					{
						SaveManager.getInstance().stop();
						SaveManager.getInstance().start(TestCorePlugin.getDefault().getPluginPreferences().getLong(TestCorePreferences.SAVE_INTERVAL));
					}
				}
			}
		};
		TestCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener(listener);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		Preferences testcorePrefs = TestCorePlugin.getDefault().getPluginPreferences();
		testcorePrefs.setDefault(TestCorePreferences.SAVE_INTERVAL, 5000);			
		testcorePrefs.setDefault(TestCorePreferences.DEFAULT_PORT, "10002"); //$NON-NLS-1$
		testcorePrefs.setDefault(TestCorePreferences.DEFAULT_HOST_NAME, "localhost"); //$NON-NLS-1$
		monitorPreferences();
	}

}
