/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CreateContainerChange.java,v 1.3 2007/05/02 19:36:14 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.internal.changes;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.hyades.models.common.util.ResourceUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * Change that creates a container.
 * @author jcanches
 * @since 4.3
 */
public class CreateContainerChange extends PotentialChange {

	private IContainer container;

	public CreateContainerChange(IContainer container) {
		this.container = container;
	}
	
	public Object getModifiedElement() {
		return container;
	}

	public String getName() {
		return NLS.bind(ChangesMessages.CREATE_CONTAINER, container.getFullPath().toString());
	}

	public void initializeValidationData(IProgressMonitor pm) {
		// NOP
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException,	OperationCanceledException {
		return new RefactoringStatus();
	}

	public Change perform(IProgressMonitor monitor) throws CoreException {
		ResourceUtil.createContainer(container, monitor);
		return null;
	}

	public boolean hasEffect() {
		return !container.isAccessible();
	}

}
