/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CreatePackageFragmentChange.java,v 1.3 2007/04/26 18:49:47 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.internal.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * Change that creates a java package.
 * @author jcanches
 * @since 4.3
 */
public class CreatePackageFragmentChange extends PotentialChange {

	private IPackageFragmentRoot sourceFolder;
	private String packageName;

	public CreatePackageFragmentChange(IPackageFragmentRoot sourceFolder, String packageName) {
		this.sourceFolder = sourceFolder;
		this.packageName = packageName;
	}
	
	public boolean hasEffect() {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(sourceFolder.getPath().append(packageName));
        return resource==null || ((resource != null) && (!resource.exists()));
	}

	public Object getModifiedElement() {
		return sourceFolder;
	}

	public String getName() {
		return NLS.bind(ChangesMessages.CREATE_PACKAGE, packageName); 
	}

	public void initializeValidationData(IProgressMonitor monitor) {
		// NOP
	}

	public RefactoringStatus isValid(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
		RefactoringStatus status = new RefactoringStatus();
        boolean isProject = (sourceFolder.getResource().getType()==IResource.PROJECT);
        if (isProject && !sourceFolder.getResource().exists()) {
            //- sourceFolder.exists() always returns false if it is a project
            status.addFatalError(ChangesMessages.NO_SOURCE_FOLDER);
        } else if (!isProject && !sourceFolder.exists()) {
            status.addFatalError(ChangesMessages.NO_SOURCE_FOLDER);
        } else if (!isProject && sourceFolder.getResource().getType() != IResource.FOLDER) {
            status.addFatalError(ChangesMessages.NOT_A_SOURCE_FOLDER);
        }
        return status;
	}

	public Change perform(IProgressMonitor monitor) throws CoreException {
		sourceFolder.createPackageFragment(packageName, true, monitor);
		return null;
	}

}
