/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PotentialChange.java,v 1.4 2007/05/03 16:56:23 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.internal.changes;

import org.eclipse.ltk.core.refactoring.Change;

/**
 * Change that may be a NO-OP.
 * @author jcanches
 * @since 4.3
 */
public abstract class PotentialChange extends Change {

	/**
	 * Determines if the change would have any real effect, if it was applied.
	 * If the method returns <code>false</code>, then the effect of the change is
	 * equivalent to {@link org.eclipse.ltk.core.refactoring.NullChange}.
	 * @return <code>true</code> if and only if applying the change have a real effect.
	 */
	public abstract boolean hasEffect();
	
}
