/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: JavaLaunchconfigDatapoolHandler.java,v 1.1 2008/05/09 18:08:50 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.core.internal.launch.datapool.extensions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.core.launch.extensions.ILaunchconfigDatapoolHandler;

/**
 * Implementation of the {@link ILaunchconfigDatapoolHandler} interface for Java-based tests
 * (for example, JUnit and HTTP tests).  The class is used by the implementation of the 
 * <code>org.eclipse.hyades.test.core.launchconfigDatapoolHandler</code> extension point 
 * in the plug-in.  
 * <p/>
 * This class determines the collection of all datapools used by a Java-based test.  If any of 
 * the datapools, if any, are encrypted, the user will be prompted for the password for each 
 * encrypted datapool during test execution.
 * <p/>
 * 
 * 
 * @author  Huang Xin Ying
 * @author  Paul E. Slauenwhite
 * @version May 6, 2008
 * @since   March 20, 2008
 */
public class JavaLaunchconfigDatapoolHandler implements ILaunchconfigDatapoolHandler {
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.core.launch.extensions.ILaunchconfigDatapoolHandler#getAllDatapools(org.eclipse.hyades.models.common.testprofile.TPFTest, org.eclipse.hyades.models.common.testprofile.TPFDeployment)
	 */
	public DPLDatapool[] getAllDatapools(TPFTest test, TPFDeployment deploy) {
		
		if(deploy != null){
		
			List encryptedDPLDatapools = new ArrayList();
			Iterator artifactLocationsIterator = deploy.getArtifactLocations().iterator();

			while(artifactLocationsIterator.hasNext()){

				CFGArtifactLocationPair artifactLocationPair = ((CFGArtifactLocationPair)(artifactLocationsIterator.next()));

				if((artifactLocationPair != null) && (artifactLocationPair.getArtifact() != null)){

					Iterator deployableInstancesIterator = artifactLocationPair.getArtifact().getDeployableInstances().iterator();

					while(deployableInstancesIterator.hasNext()){

						CFGClass cfgClass = ((CFGClass)(deployableInstancesIterator.next()));

						if((cfgClass instanceof DPLDatapool) && ((((DPLDatapool)(cfgClass))).getChallenge() != null)){					
							encryptedDPLDatapools.add(cfgClass);
						}
					}
				}
			}

			if(encryptedDPLDatapools.size() > 0){			
				return ((DPLDatapool[])(encryptedDPLDatapools.toArray(new DPLDatapool[]{})));
			}	
		}

		return null;
	}
}
