/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultExecutionHistoryDefaultsProvider.java,v 1.5 2007/03/22 14:42:34 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.internal.launch.extensions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.core.internal.resources.TestCorePluginResourceBundle;
import org.eclipse.hyades.test.core.launch.extensions.IExecutionHistoryDefaultsProviderExtended;
import org.eclipse.hyades.test.core.util.EMFUtil;

/**
 * This is the default ExecutionHistoryDefaults provider used by the Execution Results tab
 * when there is no specific extension for the test type that provides an
 * ExecutionHistoryDefaultsProvider.
 * This provider provides the test element name as the default name for the Execution Results name.
 * It provides the project of the test element resource as default location.
 * It always return false for the default Override State.
 * @author jcanches
 */
public class DefaultExecutionHistoryDefaultsProvider implements IExecutionHistoryDefaultsProviderExtended {
	
	/**
	 * Returns the name of the testElement as the default name.
	 * If the testElement is unnamed, returns a default computer-generated name with the default
	 * localized prefix. This method never returns null.
	 */
	public String getDefaultName(Object testElement) {
		String name = null;
		if (testElement != null) {
			if (testElement instanceof CMNNamedElement) {
				name = ((CMNNamedElement)testElement).getName();
			}
		}
		if (name == null) {
			name = TestCorePluginResourceBundle.ExecutionHistoryTab_defaultTestName; 
			String uniqueSuffix = Long.toString(System.currentTimeMillis());
			name = name + "_" + uniqueSuffix; //$NON-NLS-1$
		}
		return name;
	}
	
	/**
	 * Returns false as the default override state.
	 */
	public boolean getDefaultOverrideState(Object testElement) {
		return false;
	}
	
	/**
	 * If the testElement is an EMF Object, returns the project that contains the EMF Object Resource.
	 * Otherwise, returns null.
	 */
	public IContainer getDefaultLocation(Object testElement) {
		if (testElement != null && testElement instanceof EObject) {
			IFile file = EMFUtil.getWorkspaceFile((EObject)testElement);
			if (file != null) {
				return file.getProject();
			}
		}
		// Otherwise, we don't know. Return null (the user will have to specify a location).
		return null;
	}
	

	/**
	 * Returns false as the default database state.
	 */
	public boolean getDefaultDatabaseState(Object testElement) {
		return false;
	}


	/**
	 * Returns false as the default defer model load state.
	 */
	public boolean getDefaultTestLogFileState(Object testElement) {
		return false;
	}
}
