/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestComponentLaunchConfigurationFacade.java,v 1.4 2005/06/10 15:44:42 jcanches Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.launch.configurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;

/**
 * <p>This class is a Facade for accessing Test Component information in a TPTP launch
 * configuration.</p>
 * <p><b>Please note that Test Component UI support is incomplete in TPTP 4.0 and these APIs are
 * provisional. They may be subject to changes in future releases.</b></p>
 * <p>This facade manages the following properties:
 * <ul>
 *   <li>test (TPFTest): the test that should be deployed and executed when launching
 *   a TPTP launch configuration.</li>
 * </ul></p>
 * @author jcanches
 */
public class TestComponentLaunchConfigurationFacade extends AbstractLaunchConfigurationFacade {
	
	public final static String LAUNCH_CONFIGURATION_TYPE =  "org.eclipse.hyades.test.ui.launch.basicTestComponent"; //$NON-NLS-1$
	
	public static ILaunchConfigurationType getLaunchConfigurationType() {
		return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(LAUNCH_CONFIGURATION_TYPE);
	}
	
	private final static String PROPERTY_TEST_COMPONENT = PROPERTY_PREFIX + ".testComponent"; //$NON-NLS-1$
	
	/**
	 * Retrieves the TestComponent property of a TPTP Launch Configuration. This property defines
	 * which Test Component will be run by the Launch Configuration.
	 * @param configuration
	 * @param resourceSet
	 * @since 3.1
	 */
	public synchronized static TPFTestComponent getTestComponent(ILaunchConfiguration configuration, ResourceSet resourceSet) throws CoreException {
		EObject eObject = resolveEMFReference(configuration, PROPERTY_TEST_COMPONENT, resourceSet);
		if (eObject != null && eObject instanceof TPFTestComponent) {
			return (TPFTestComponent)eObject;
		}
		return null;
	}
	
	/**
	 * Sets the TestComponent property of a TPTP Launch Configuration. This property defines
	 * which Test Component will be run by the Launch Configuration.
	 */	
	public synchronized static void setTestComponent(ILaunchConfigurationWorkingCopy configuration, TPFTestComponent testComponent) {
		storeEMFReference(configuration, PROPERTY_TEST_COMPONENT, testComponent);
	}
	
}
