/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BasicTestComponentLaunchConfigurationDelegate2.java,v 1.6 2007/03/22 14:42:35 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.launch.delegates;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.core.internal.resources.TestCorePluginResourceBundle;
import org.eclipse.hyades.test.core.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.core.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.core.launch.configurations.TestComponentLaunchConfigurationFacade;

/**
 * <p>This class is the delegate for the TPTP Test Component launch configuration.
 * It handles the launching of a TPTP Test Component according to a TPTP Test Component
 * launch configuration.</p>
 * <p><b>Please note that Test Component UI support is incomplete in TPTP 4.0 and these APIs are
 * provisional. They may be subject to changes in future releases.</b></p>
 * @see org.eclipse.debug.core.model.ILaunchConfigurationDelegate
 * @author jcanches
 */
public abstract class BasicTestComponentLaunchConfigurationDelegate2 extends AbstractLaunchConfigurationDelegate2 {
	
    /**
     * Create a Hyades Basic Launch Configuration Delegate.
     */
    public BasicTestComponentLaunchConfigurationDelegate2() {
    }

    protected TPFTestComponent getLaunchedTestComponent(ILaunchConfiguration configuration) throws CoreException {
    	return TestComponentLaunchConfigurationFacade.getTestComponent(configuration, getResourceSet());
    }
    
    protected TPFDeployment getDeployment(ILaunchConfiguration configuration) throws CoreException {
    	return DeploymentLaunchConfigurationFacade.getDeployment(configuration, getResourceSet());
    }
    
    protected String getTestExecutionHistoryName(ILaunchConfiguration configuration) throws CoreException {
    	return ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryName(configuration);
    }
    
    protected IContainer getTestExecutionHistoryLocation(ILaunchConfiguration configuration) throws CoreException {
    	return ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryLocation(configuration);
    }   
    
	protected Object getLaunchedElement(ILaunchConfiguration configuration)	throws CoreException {
		return getLaunchedTestComponent(configuration);
	}
	
    protected void validate(ILaunchConfiguration configuration, String mode) throws CoreException {
    	super.validate(configuration, mode);
   	
    	if (getDeployment(configuration) == null) {
			reportProblem(TestCorePluginResourceBundle._EXC_BasicTestLaunchConfigurationDelegate2_noDeployment); 
		}
    	
    	String tehName = getTestExecutionHistoryName(configuration);
    	if (tehName == null || tehName.equals("")) { //$NON-NLS-1$
    		reportProblem(TestCorePluginResourceBundle._EXC_BasicTestLaunchConfigurationDelegate2_noExecName); 
    	}
    	
    	IContainer tehLocation = getTestExecutionHistoryLocation(configuration);
    	if (tehLocation == null) {
    		reportProblem(TestCorePluginResourceBundle._EXC_BasicTestLaunchConfigurationDelegate2_noExecLocation); 
    	} else if (!tehLocation.exists()) {
    		reportProblem(TestCorePluginResourceBundle._EXC_BasicTestLaunchConfigurationDelegate2_locationDNE); 
    	}
    }
        
}
