/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExecutionHistoryDefaultsProvider.java,v 1.3 2005/06/10 15:44:42 jcanches Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.launch.extensions;

import org.eclipse.core.resources.IContainer;

/**
 * <p>This interface is to be implemented by plugins extending the
 * <code>org.eclipse.hyades.test.core.launchconfigExecutionHistoryDefaults</<code>
 * extension point.</p>
 * <p>Classes implementing this interface are responsible of providing default values
 * for the Test Log tab in the Test launch configuration.</p>
 * @author jcanches
 */
public interface IExecutionHistoryDefaultsProvider {
	
	/**
	 * Returns the default test log name for the given testElement.
	 * @param testElement an instance of a runnable entity. This may be an instance of
	 * TPFTest or of TPFTestComponent. Other types of object may be added in the future.
	 * @return The default name for the test log produced by the execution
	 * of the supplied element.
	 */
	String getDefaultName(Object testElement);
	
	/**
	 * Return the default state for the "Overwrite" check box for the given testElement.
	 * TPTP default is false.<br>
	 * State <code>false</code> means that an existing resource with the supplied name will not be
	 * overwritten if it already exists. In that case, a unique name will be generated,
	 * starting with the supplied name.
	 * @param testElement This may be an instance of
	 * TPFTest or of TPFTestComponent. Other types of object may be added in the future.
	 * @return <code>false</code> for leaving the check box unchecked, <code>true</code> otherwise.
	 */
	boolean getDefaultOverrideState(Object testElement);
	
	/**
	 * Returns the default test log location for the given testElement.
	 * @param testElement an instance of a runnable entity. This may be an instance of
	 * TPFTest or of TPFTestComponent. Other types of object may be added in the future.
	 * @return The default location for the test log produced by the execution
	 * of the supplied element. This should be an instance of a workspace project or folder.
	 */
	IContainer getDefaultLocation(Object testElement);
	
}
