/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.launch.extensions;

import org.eclipse.debug.core.ILaunchConfiguration;

/**
 * @author jtoomey
 * @provisional As of TPTP V4.4.0, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
 */
public interface IExecutionHistoryDefaultsProvider2Extended extends
		IExecutionHistoryDefaultsProvider2 {
	
	/**
	 * Return the default state for the "Database" check box for the given Launch
	 * Configuration.
	 * TPTP default is false.<br>
	 * State <code>false</code> means that the test log data will be loaded into 
	 * the specified target as an XMI-persisted EMF model during/after test 
	 * execution.
	 * State of <code>true</code> means that the test log data will be written
	 * to an RDBMS-persisted model during / after test execution 
	 * @param launchConfiguration A launch configuration.
	 * @return <code>false</code> for leaving the check box unchecked, <code>true</code> otherwise.
	 */
	boolean getDefaultDatabaseState(ILaunchConfiguration launchConfiguration);

	/**
	 * Return the default state for the "Defer model loading of test results" 
	 * check box for the given Launch Configuration.
	 * TPTP default is false.<br>
	 * State <code>false</code> means that the test log data from the executed 
	 * test will be automatically loaded into the TPTP model during / after test
	 * execution.
	 * State of <code>true</code> means that the test log data will not be 
	 * loaded into the TPTP model, but will instead be written to disk exactly as
	 * transmitted by the test runner, and can later be used for filtering, 
	 * importing, etc.
	 * @param launchConfiguration A launch configuration.
	 * @return <code>false</code> for leaving the check box unchecked, <code>true</code> otherwise.
	 */
	boolean getDefaultTestLogFileState(ILaunchConfiguration launchConfiguration);
	

}
