/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExecutionResultsLocationFilter.java,v 1.3 2005/06/10 15:44:42 jcanches Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.launch.extensions;

import org.eclipse.core.resources.IContainer;

/**
 * <p>This interface is to be implemented by plugins extending the
 * <code>org.eclipse.hyades.test.core.launchconfigExecutionHistoryLocationFilter</<code>
 * extension point.</p>
 * <p>Classes implementing this interface are responsible of determining whether
 * a certain location should be proposed or not as a container for test log locations.
 * @author jcanches
 */
public interface IExecutionResultsLocationFilter {
	
	/**
	 * Returns <code>true</code> if the specified location should not be displayed
	 * in the available locations in the "Test Log" tab of a
	 * Test launch configuration. Note that the return value of this method
	 * should be always the same for a given configuration.
	 * @param location
	 * @return
	 */
	boolean isFiltered(IContainer location);

}
