/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ILaunchconfigDatapoolHandler.java,v 1.1 2008/03/20 17:49:28 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.hyades.test.core.launch.extensions;

import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;

/**
*  
* It's the interface for the launchconfigDatapoolHandler extension point.
* 
* @author Huang Xin Ying 
* @version February 27, 2008
* @provisional Provisional API as of TPTP 4.5.0.
*/
public interface ILaunchconfigDatapoolHandler {
	
	/**
	 * Used to get all encrypted datapool's names from TPFTest and TPFDeployment 
	 * while running testsuite.
	 * @param test
	 * @param deploy
	 * @return DPLDatapool[]
	 */
	public	DPLDatapool[] getAllDatapools(TPFTest test, TPFDeployment deploy);

}
