/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: IPassInfoCollector.java,v 1.1 2008/03/20 17:49:28 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.core.launch.extensions;

import java.util.List;
import java.util.Map;

import org.eclipse.hyades.models.common.datapool.DPLDatapool;

/**
*  
* It's the interface for the launchDatapoolCheckPass extension point.

* @author Huang Xin Ying 
* @version February 27, 2008
* @provisional Provisional API as of TPTP 4.5.0.
*/
public interface IPassInfoCollector {
	
	/**
	 * Create a dialog to prompt user input the passwords for encrypted datapools
	 *  while running a test suite .
	 * @param dp
	 * @param pass
	 * @param isContinue
	 */
	void execute(DPLDatapool[] dp, Map pass, List isContinue);
}
