/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITestLaunchConfigurationValidator.java,v 1.6 2007/05/03 18:20:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.launch.extensions;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.ecore.resource.ResourceSet;

/**
 * <p>This interface is to be implemented by plugins extending the
 * <code>org.eclipse.hyades.test.core.launchconfigValidator</<code>
 * extension point.</p>
 * <p>The method <code>validate</code> is invoked from any launch configuration that contains
 * the Test or TestComponent tab, to diagnose whether the configuration has errors
 * or warnings.</p>
 * @author jcanches
 */
public interface ITestLaunchConfigurationValidator {
	
	/**
	 * Interface used for describing the result of a validation.
	 * @author jcanches
	 */
	public interface Diagnostic {
		/**
		 * Denotes an ERROR diagnostic.
		 */
		public final static int ERROR = 0;
		/**
		 * Denotes a WARNING diagnostic.
		 */
		public final static int WARNING = 1;
        /**
         * Denotes a OK diagnostic.
         */
        public final static int OK = 2;
		/**
		 * Returns a message describing the nature of the error or warning.
		 * @return
		 */
		String getMessage();
		/**
		 * Returns the severity of the diagnostic. This is either ERROR, WARNING or OK.
		 * @return
		 */
		int getSeverity();
	}
	
	/**
	 * Returns a diagnostic if the Launch Configuration has problems.
	 * Returns <code>null</code> if there are no problems with the Launch Configuration.
	 * @param launchConfiguration A launch configuration.
	 * @param resourceSet The resource set that should be used for loading EMF objects,
	 * if required.
	 * @return A Diagnostic if there is problem with the launch configuration, or <code>null</code>
	 * otherwise.
	 */
	Diagnostic validate(ILaunchConfiguration launchConfiguration, ResourceSet resourceSet);
	
}
