/********************************************************************** 
 * Copyright (c) 2005, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: AbstractResourceContentsExtractionService.java,v 1.6 2009/11/23 20:40:45 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.core.services;

import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.hyades.automation.server.AbstractRelaunchableService;

/**
 * Work in progress (currently under development and not functional yet)
 * 
 * @author Scott E. Schneider
 */
public abstract class AbstractResourceContentsExtractionService extends
		AbstractRelaunchableService {

	private static final long serialVersionUID = -8962775290443718533L;

	/**
	 * Default constructor invokes up hierarchy for any initialization required
	 */
	protected AbstractResourceContentsExtractionService() {
		super();
	}

	/**
	 * Cleanup after service executes
	 */
	protected void cleanup() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.automation.core.Service#execute()
	 */
	public final Object execute() {

		// Entire execution in throwable catch block
		try {

			// Execute common execute behavior before service specific
			Object object = super.execute();

			// If base class decides to abort this execution early (to restart)
			//NOTE: When this is changed to IApplication.EXIT_OK, we will need to change it everywhere otherwise this condition may return false since the objects are not the same:
			if (object != IPlatformRunnable.EXIT_OK) {
				return object;
			}

			// Extract resource contents as instructed
			this.extract();

		} catch (Throwable t) {

			// Handle throwable during execution
			this.handleThrowable(t);

		} finally {

			// Invoke cleanup
			this.cleanup();

		}

		// Prepare and set return state
		return this.returnResult();

	}

	/**
	 * Extract content from the specified resource
	 */
	protected void extract() {
	}

	/**
	 * Default outputs throwable to standard console out
	 * 
	 * @param t
	 *            the throwable caught to be handled
	 */
	protected void handleThrowable(Throwable t) {
		t.printStackTrace();
	}

	/**
	 * Derive result to return
	 * 
	 * @return the result to return, service-level not semantic-level per
	 *         service domain
	 */
	protected Object returnResult() {
		return this;
	}

}
