/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestGenerator.java,v 1.4 2008/03/11 17:57:02 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.core.testgen;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.core.internal.resources.TestCorePluginResourceBundle;

/**
 * Object to be extended by objects which will generate tests in the Testgen infrastructure
 * This object is associated with extension point org.eclipse.hyades.execution.testgen.TestGenerator
 * @author Ernest Jessee
 */
public abstract class TestGenerator implements Runnable
{
	
	
	/**
	 * reference to the .recmodel file associated with the generated test
	 */
	protected IFile recModelFile = null;
	
	/**
	 * the output filename (ends with .testsuite)
	 */
	protected String outputFileName = null;	
	
	/**
	 * testgen completed successfully
	 */
	private boolean bSuccess=false;
	
	protected IProgressMonitor monitor = new NullProgressMonitor();
	
	private int nProgress;
	/**
	 * method called to begin test generation
	 * @return
	 * @throws TestgenException
	 * @deprecated 
	 */
	public abstract boolean runTestGen() throws TestgenException;
	
	public boolean runTestGen(IProgressMonitor monitor) throws TestgenException
	{
		this.monitor = monitor;
		monitor.beginTask(getJobTitle(), 100);
		boolean b= runTestGen();
		monitor.done();
		return b;
	}
	/**
	 * method called to determine whether or not a progress dialog should be shown with test generation.
	 * @return
	 */
	public abstract boolean showProgress();
	
	
	
	
	/**
	 * method called to initialize the Test Generator with needed information and references
	 * @param recModelFile
	 * @param outputFileName
	 */	
	public void initialize(IFile recModelFile, String outputFileName)
	{
		initialize(recModelFile, outputFileName, new NullProgressMonitor());
	}

	public void initialize(IFile recModelFile, String outputFileName, IProgressMonitor monitor)
	{
		this.recModelFile = recModelFile;
		this.outputFileName = outputFileName;
		this.monitor = monitor;
	}
	/**
	 * this method is called by the display to perform the test generation.  Testgenerators are executed via Display.getDefault().asyncExec(Runnable);	 * 
	 */
	public void run()
	{
		try {
			bSuccess = runTestGen();
		}
		catch (TestgenException e)
		{
			bSuccess = false;
			TestCorePlugin.getDefault().logError(e);
		}
	}
	
	/**
	 * called to set the percent complete of the progress dialog
	 * @param percentComplete
	 * @deprecated - use IProgressMonitor directly
	 */
	public void setProgress(int percentComplete)
	{
		if (nProgress < percentComplete)
		{
			monitor.worked(percentComplete - nProgress);
			nProgress = percentComplete;
		}
	}
	
	
	/**
	 * called to change the displayed message on the progress dialog.
	 * These messages must be localized
	 * @param message
	 * @deprecated - use IProgressMonitor
	 */
	public void setMessage(String message)
	{
		monitor.setTaskName(message);
	}
	
	/**
	 * called to close the progress dialog
	 * @deprecated - use IProgressMonitor
	 */
	public void closeProgressDialog()
	{
		monitor.done();
	}

	/**
	 * @return
	 */
	public boolean isSuccess() {
		return bSuccess;
	}

	public String getOutputFileName() {
		return outputFileName;
	}
	
	/**
	 * returns a string to be used as a job name
	 * @return
	 */
	public String getJobTitle() {
		return TestCorePluginResourceBundle.TestGenerator_JOB_NAME;
	}
}