/**********************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestGenerator2.java,v 1.2 2009/09/24 17:31:33 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.core.testgen;

/**
 * <p>Extension of the {@link TestGenerator} abstract class, adding 
 * support for accessing multiple output files created during generation.</p>
 * 
 * 
 * @author  Jeff Nevicosi
 * @author  Paul E. Slauenwhite
 * @version September 24, 2009
 * @since   September 24, 2009
 * @see     TestGenerator
 * @provisional As of TPTP V4.5.2.1, this is stable provisional API (see http://www.eclipse.org/tptp/home/documents/process/development/api_contract.html).
 */
public abstract class TestGenerator2 extends TestGenerator {

	/**
	 * <p>Resolves the workspace-relative paths to the output files created during generation.</p>
	 * 
	 * <p>Note, the output files resolved by this method <i>may</i> or <i>may not</i> include the output file returned by the 
	 * {@link TestGenerator#getOutputFileName()} method, which is the user-specified output file name.  For example, 
	 * if the user specifies to generate a file named <code>/test_project/a.testsuite</code> but the actual generation 
	 * creates <code>/test_project/b.testsuite</code> and <code>/test_project/c.testsuite</code> but <code>/test_project/a.testsuite</code> is empty, the methods could 
	 * return the following:</p> 
	 * 
	 * 
	 * <code>getOutputFileName()</code> -> <code>/test_project/a.testsuite</code>
	 * <code>getOutputFiles()</code> -> <code>/test_project/b.testsuite</code> and <code>/test_project/c.testsuite</code>
	 *   
	 * @return Workspace-relative paths to the output files created during generation.
	 * @see    #getOutputFileName()
	 */
	public abstract String[] getOutputFiles();
}
