/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestgenException.java,v 1.3 2005/06/17 16:16:04 jnevicos Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.core.testgen;


/**
 * Exception thrown by testgen
 * @author dhinson
 */
public class TestgenException extends Exception
{
	static final long serialVersionUID = 4106476283860669989L;
	private Exception exception;
	
	public TestgenException (String message)
	{
		super(message);
	}

	public TestgenException (String message, Exception exception)
	{
		super(message);
		this.exception = exception;
	}

	public String getMessage ()
	{
		String message = super.getMessage();	
		if (message == null && exception != null)
			return exception.getMessage();
		else
			return message;
	}

	public void dumpMessages (java.io.PrintStream stream)
	{
		String message = super.getMessage();
		if (message != null)
			stream.print(message);
		stream.print(": ");
		if (exception != null)
			stream.print(exception.getMessage());
		stream.println();
	}
}
