/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: DatapoolPasswordsService.java,v 1.1 2008/03/20 17:49:28 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.core.testservices.resources;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.hyades.execution.local.testservices.AbstractTestService;
import org.eclipse.hyades.execution.local.testservices.ITestService;
import org.eclipse.hyades.internal.execution.local.control.Agent;

/**
*  
* It's the class of DatapoolPasswordsService ,used to provide list of datapool and it's encryption 
* password to the agent controller side.
*
* @author Huang Xin Ying 
* @version February 27, 2008
* @provisional Provisional API as of TPTP 4.5.0.
*/
public class DatapoolPasswordsService extends AbstractTestService implements ITestService{
	
	/**
	 * @param agent
	 * @param methodArgs
	 * @param errBuf
	 * @return The String  made up by the encrypted datapool's names and it's passwords
	 */
	public String getDatapoolList(Agent agent, String methodArgs, StringBuffer errBuf){
		Pattern pattern = Pattern.compile("testId=(.*)"); //$NON-NLS-1$
		Matcher matcher = pattern.matcher(methodArgs);
		String testId = null;
		if (matcher.find()) {
			testId = matcher.group(1);
		}
		HashMap data = PasswordCollection.getInstance().getDatapoolPassword(testId);
		
		if(data == null || data.size() == 0)
			return null;
		
		StringBuffer result = new StringBuffer();
		
		for( Iterator it = data.entrySet().iterator();it.hasNext();){
			Map.Entry entry = (Map.Entry)it.next();
			result.append(entry.getKey() + "=" + entry.getValue() + ";");
		}
		
		return result.toString();
	}	
}
