/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: PasswordCollection.java,v 1.1 2008/03/20 17:49:28 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 

package org.eclipse.hyades.test.core.testservices.resources;



import java.util.HashMap;

/**
 * This class runs on the workbench, and used to save HashMap of
 *  datapool & password for this datapool during luaching  tests ;
 * It's supposed to support mult-lauch on the workbench side. 
 *
 * @author Xin Ying Huang
 * @version February 27, 2008
 * @provisional Provisional API as of TPTP 4.5.0.
 */
public class PasswordCollection {
	
	private static PasswordCollection instance = null;
	private HashMap datapoolPassword = new HashMap();
	
	
	private PasswordCollection(){}
	
	/**
	 * @param 
	 * @return PasswordCollection
	 */
	public static PasswordCollection getInstance(){
		if(instance == null){
			instance = new PasswordCollection();
		}
		return instance;
	}	
   
	/**
	 * @param 
	 * @return HashMap
	 */
	public HashMap getDatapoolPassword() {
		return datapoolPassword;
	}
	
	/**
	 * @param  testId
	 * @return HashMap
	 */
	public HashMap getDatapoolPassword(String testId){
		if(testId == null)
			return null;
		return (HashMap)datapoolPassword.get(testId);
	}
	
	/**
	 * @param  testId
	 * @return HashMap
	 */
	public void clear(String testId){
		if(testId == null)
			return;
		datapoolPassword.remove(testId);
		return;
	}
}
