/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: WorkspaceResourceProviderService.java,v 1.9 2008/02/28 17:04:26 jkubasta Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.core.testservices.resources;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.execution.local.testservices.ITestService;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.osgi.util.NLS;

/**
 * This class runs on the workbench, and provides the workbench side 
 * implementation of the WorkspaceResourceProvider service.
 * 
 * @author jtoomey
 *
 */
public class WorkspaceResourceProviderService extends FilesystemResourceProviderService implements ITestService {

	/**
	 * @param methodArgs
	 * @return
	 */
	public String listChildren(Agent agent, String methodArgs, StringBuffer errBuf) {
		String result = null;
		Pattern pattern = Pattern.compile("parent=(.*)"); //$NON-NLS-1$
		Matcher matcher = pattern.matcher(methodArgs);
		
		if (matcher.find()) {
			String file = matcher.group(1);
			IContainer container = null;
			IResource resource = getWorkspaceResource(file);

			if (resource != null && resource instanceof IContainer)
				container = (IContainer)resource;

			if (container != null) {
				IResource[] children = null;
				try {
					children = container.members();
				} catch (CoreException e) {
				}
				if (children != null && children.length > 0) {
					StringBuffer returnVal = new StringBuffer("Children:"); //$NON-NLS-1$
					for (int i = 0; i < children.length; i++) {
						if (i > 0)
							returnVal.append(",");
						returnVal.append(children[i].getName());
					}
					result = returnVal.toString();
				}
			}
		}
		else {
			errBuf.append(NLS.bind(Messages.WorkspaceResourceProviderService_BAD_PARAMS, methodArgs)); 
		}
		
		if (result == null && errBuf.length() == 0)
			// Indicates empty child set
			result = "Children=";
		return result;			
	}
	
	
	/**
	 * @param file
	 * @return
	 */
	private IResource getWorkspaceResource(String file) {
		IResource resource = null;
		
		if (file.equalsIgnoreCase(ROOT)) {
			resource = ResourcesPlugin.getWorkspace().getRoot();
		}
		else {
			resource = ResourcesPlugin.getWorkspace().getRoot().findMember(file);
		}
		
		return resource;
	}
	
	/**
	 * @param source
	 * @return
	 */
	private String getPathToWorkspaceFile(String source) {
		IResource fileResource = ResourcesPlugin.getWorkspace().getRoot().findMember(
				source);
		if (fileResource != null)
			return fileResource.getLocation().toString();
		else
			return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.core.testservices.resources.FilesystemResourceProviderService#exists(java.lang.String)
	 */
	protected boolean exists(String file) {
		return getPathToWorkspaceFile(file) != null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.core.testservices.resources.FilesystemResourceProviderService#resolvePath(java.lang.String)
	 */
	protected String resolvePath(String source) {
		return getPathToWorkspaceFile(source);
	}

}
