/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CoreUtil.java,v 1.4 2005/02/25 22:17:53 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.util;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/**
 * Contains non UI utility methods.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class CoreUtil {
	
	/**
	 * Removes the bit flag from the integer value returning the new 
	 * value.
	 * @param value
	 * @param flag
	 * @return int
	 */
	public static int removeBitFlag(int value, int flag)
	{
		return (~((~value) | flag));
	}

	/**
	 * Returns the integer value for the bits passed as a String.  Example:
	 * 5 = fromBynaryString("101") and 10 = fromBynaryString("1010");
	 * 
	 * <p>Any character different than 1 is considered 0.
	 * 
	 * @param bits
	 * @return int
	 */
	public static int fromBynaryString(String bits)
	{
		int ret = 0;
		
		int length = bits.length();
		for(int i=length; i>0; i--)
		{
			if(bits.charAt(i-1) == '1')
				ret += Math.pow(2, (length-i));				
		}
		
		return ret;
	}
	
	/**
	 * Changes the owner list by moving all the specified elements up.  If one element
	 * is at the top, it is not moved.
	 * @param owner
	 * @param elements
	 */
	public static void moveUp(List owner, List elements)
	{
		if((owner == null) || owner.isEmpty() || (elements == null) || elements.isEmpty())
			return;

		int top = 0;
		for(Iterator i=elements.iterator(); i.hasNext(); )
		{
			Object element = i.next();
			int index = owner.indexOf(element);
			if(index < 0)
				continue;
				
			if(index > top)
				swap(owner, index, index-1);
			else
				top++;
		}		
	}
	
	/**
	 * Changes the owner list by moving all the specified elements down.  If one element
	 * is at the botton, it is not moved.
	 * @param owner
	 * @param elements
	 */
	public static void moveDown(List owner, List elements)
	{
		if((owner == null) || owner.isEmpty() || (elements == null) || elements.isEmpty())
			return;
						
		int botton = owner.size()-1;
		for(ListIterator i=elements.listIterator(elements.size()); i.hasPrevious(); )
		{
			Object element = i.previous();
			int index = owner.indexOf(element);
			if(index < 0)
				continue;

			if(index < botton)
				swap(owner, index, index+1);
			else
				botton--;
		}
	}
	
	/**
	 * This method swaps two elements in a list identified by their indexes.  The
	 * elements are remvoed from the list and them reinserted which is save when
	 * manipulating unique lists.   
	 * @param list
	 * @param index1
	 * @param index2
	 */
	public static void swap(List list, int index1, int index2)
	{
		if((list == null) || (index1 == index2))
			return;


		int lastIndex = list.size()-1;
		if((index1 > lastIndex) || (index2 > lastIndex) || (index1 < 0) || (index2 < 0))
			return;


		if(index1 > index2)
		{
			int index = index2;
			index2 = index1;
			index1 = index;
		}
		
		Object o1 = list.get(index1);
		Object o2 = list.get(index2);


		list.remove(o1);
		list.remove(o2);
		
		list.add(index1, o2);
		list.add(index2, o1);	
	}
}
