/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeploymentUtil.java,v 1.2 2005/02/25 22:17:53 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.core.util;

import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * This class provides a central place for utility functions used to handle 
 * {@link org.eclipse.hyades.models.common.testprofile.TPFDeployment} resources.
 * 
 * @author bjiang
 * @since  3.0
 */
public class DeploymentUtil 
{
	public static CFGArtifactLocationPair associateTestAsset(CFGClass testAsset, TPFDeployment deployment)
	{
		CFGArtifactLocationPair pair = ConfigurationUtil.searchPairWithTestAsset(testAsset, deployment);
		if(pair == null)
		{
			// create objects in memory if they don't exist on disk
			CFGArtifact artifact = ConfigurationUtil.searchArtifactWithTestAsset(testAsset, deployment);
			if(artifact == null)
			{
				artifact = ConfigurationUtil.createArtifact(null, null);
				deployment.getArtifacts().add(artifact);
			}
			
			CFGLocation location = ConfigurationUtil.getDefaultLocation(deployment); 
			if(location == null)
			{
				location = LocationUtil.createLocation(null, null, null);
				deployment.getRefLocations().add(location);
			}
			
			pair = ConfigurationUtil.createArtifactLocationPair(artifact, location);
			deployment.getArtifactLocations().add(pair);
			if (deployment.eResource() != null) {
				// Do this only if the deployment is persisted (default deployment is not)
				deployment.eResource().setModified(true);
			}
		}
		
		CFGArtifact artifact = pair.getArtifact();
		// force CLASSPATH to be calculated if it's not there
		ArtifactUtil.associateTestAsset(testAsset, artifact);
		
		return pair;
	}
}
