/********************************************************************** 
 * Copyright (c) 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IEMFCustomDeleter.java,v 1.1 2009/09/29 20:10:41 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.test.core.util;

import org.eclipse.emf.ecore.EObject;

/**
 * <p>Interface to implement custom operation to be performed on EMF object
delete.</p>
 * 
 * <p>These custom operations are invoked from the {@link EMFUtil#remove(EObject)} method.</p>
 * 
 * 
 * @author  Jerome Bozier
 * @version September 28, 2009
 * @since   September 28, 2009
 * @see     EMFUtil
 * @see     EMFUtil#remove(EObject) 
 */
 
public interface IEMFCustomDeleter {

	/**
     * <p>Custom operation to be performed on EMF object delete.</p>
     * 
     * <p>This custom operation is invoked from the {@link EMFUtil#remove(EObject)} method.</p>
     * 
     * @param eobject The {@link EObject} to be deleted.
     * @see   EMFUtil#remove(EObject) 
     */
	public void customDelete(EObject eobject);
}
