/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultEnvironmentAdapter.java,v 1.6 2007/05/02 19:36:14 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.internal.recorder.framework;

import java.io.File;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.execution.recorder.remote.RecorderEnvironmentAdapter;
import org.eclipse.tptp.test.provisional.recorder.framework.IRecorderExecOptionsProvider;

/**
 * @author jnevicos
 *
 */
public class DefaultEnvironmentAdapter extends RecorderEnvironmentAdapter {

	IRecorderExecOptionsProvider provider;
	String recorderID;
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.remote.RecorderEnvironmentAdapter#getClassPathEntry(String)
	 */
	protected String getClassPathEntry() {

		//TODO: deploy path
		if (provider == null)
		{
			provider = RecorderFactory.getInstance().getRecorderExecOptions(recorderID, false);
		}
		if (provider == null)
		{
			//TODO: log default
			String cp = "";
			//adding both urls to classpath, so this can be done both as a runtime & debug environment.
			//THIS SETUP IS NOT RECOMMENDED FOR PRODUCT-LEVEL CODE
			try {
			
				
			IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(RecorderFactory.RECORDER_EXTENSION_ID);
			for (int i = 0; i < elements.length; i++)
			{

				if (elements[i].getAttribute("id").equals(recorderID))
				{

					Platform.resolve(Platform.getBundle(elements[i].getDeclaringExtension().getNamespace()).getEntry("bin"));
					break;
				}
			}
			
/*			if (binurl != null)
			{
				String strbin = binurl.toString();
				if (strbin.substring(0,6).equalsIgnoreCase("file:/"))
				{
					strbin = strbin.substring(6);
				}
				cp = strbin + ";" + getDeploymentPath();
			}
*/
			return getDeploymentPath();
			}
			catch (Exception e) {}
			return cp;
			
		}
		String xtra = provider.getExtraClasspathEntries();
		if (xtra == null || xtra.length() < 1)
			return getDeploymentPath();
		else
		return xtra + ";" + getDeploymentPath();
	}

	public DefaultEnvironmentAdapter(String recorderID)
	{
		this.recorderID = recorderID;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.remote.RecorderEnvironmentAdapter#getRecorderJARs()
	 */
	public File[] getRecorderJARs() {
		if (provider == null)
		{
			provider = RecorderFactory.getInstance().getRecorderExecOptions(recorderID, false);
		}
		if (provider == null)
		{
			return new File[0];
		}
		return provider.getRecorderJars();
	}
}
