/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultExecutableAdapter.java,v 1.3 2006/02/03 15:09:17 jnevicos Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.internal.recorder.framework;

import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.execution.recorder.remote.RecorderExecutableObjectAdapter;
import org.eclipse.tptp.test.provisional.recorder.framework.IRecorderExecOptionsProvider;

/**
 * @author jnevicos
 *
 */
public class DefaultExecutableAdapter extends RecorderExecutableObjectAdapter {

	IRecorderExecOptionsProvider provider;
	String recorderID;
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.remote.RecorderExecutableObjectAdapter#getAgentClassPath()
	 */
	public String getAgentClassPath() {
		if (provider == null)
		{
			provider = RecorderFactory.getInstance().getRecorderExecOptions(recorderID, false);
		}
		if (provider == null)
		{
			//TODO: log default
			return RecorderFactory.getInstance().getRecorderAgent(recorderID);
		}
		
		return RecorderFactory.getInstance().getRecorderAgent(provider.getRecorderID());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.remote.RecorderExecutableObjectAdapter#getVMArgString()
	 */
	public String getVMArgString() {
		if (provider == null)
		{
			provider = RecorderFactory.getInstance().getRecorderExecOptions(recorderID, false);
		}
		if (provider == null)  //TODO: log default
			return "";
		
		return provider.getVMArgs();
	}

	public DefaultExecutableAdapter(String recorderID)
	{
		this.recorderID = recorderID;
	}
}
