/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecorderDataProcessor.java,v 1.7 2010/03/25 16:09:44 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.internal.recorder.framework;

import java.io.IOException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.recorder.IRecorderDataProcessor;
import org.eclipse.hyades.execution.recorder.RecorderFactory;
import org.eclipse.hyades.test.core.internal.resources.TestCorePluginResourceBundle;
import org.eclipse.hyades.test.core.testgen.util.TestGenFileUtil;
import org.eclipse.tptp.test.provisional.recorder.framework.IRecorderMessageProvider;

/**
 * <p>RecorderDataProcessor.java</p>
 * 
 * 
 * @author  Jeffrey Nevicosi
 * @author  Paul Slauenwhite
 * @version March 25, 2010
 * @since   September 23, 2005
 */
public class RecorderDataProcessor implements IRecorderDataProcessor {

	private IRecorderMessageProvider provider = null;
	private String recorderID = null;
	private IFile traceFile = null;
	
	public RecorderDataProcessor(String recorderID)
	{
		this.recorderID = recorderID;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.IRecorderDataProcessor#initialize()
	 */
	public void initialize() throws IOException {
		provider = RecorderFactory.getInstance().getMessageProvider(recorderID, false);
		if (provider == null)
		{
			//TODO: log, use default
		}

		String fileName = RecorderFactory.getInstance().getRecorderWithID(recorderID).getRecordingPath();
		if (fileName != null && fileName.length() > 0)
		{
				if (provider == null){  
					
					//creation of the trace file is a requirement of the provider's init() method
					//this is because one static method cannot be accountable for creation in any & all variations
					traceFile = TestGenFileUtil.createTraceFile(fileName);
					
					if((traceFile == null) || (!traceFile.exists())){
						throw new IOException(TestCorePluginResourceBundle.RecorderDataProcessor_UNABLE_TO_CREATE_TRACE_FILE_ERROR + fileName); 
					}
				}
		}
		if (provider != null)
			provider.initialize();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.IRecorderDataProcessor#processData(byte[])
	 */
	public void processData(byte[] data) {
		if (provider != null)
		{
			provider.processDataFromDataProcessor(data);
		}

	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.IRecorderDataProcessor#processDebugString(java.lang.String)
	 */
	public void processDebugString(String debugString) {
		// TODO log message directly to error log (as info) -- replace
		System.out.println(debugString);
		RecorderLoggingUtil.info(debugString);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.IRecorderDataProcessor#processControlString(java.lang.String)
	 */
	public void processControlString(String controlString) {
		provider.processMessage(controlString);

	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.recorder.IRecorderDataProcessor#complete()
	 */
	public void complete() {
		try {
			if (traceFile != null)
				traceFile.refreshLocal(IFile.DEPTH_ZERO, new NullProgressMonitor());
		}
		catch (Exception e) {
			//TODO: log exception
		}

		if (provider != null)
			provider.complete();
	}

}
