/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecorderLoggingUtil.java,v 1.1 2005/10/27 20:10:21 jnevicos Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.internal.recorder.framework;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.test.core.TestCorePlugin;

/**
 * Error logging class (borrowed from org.eclipse.tptp.platform.analysis.core.logging.Log)
 * @author jnevicos
 */
public class RecorderLoggingUtil {

	/**
	 * Log a severe error
	 * 
	 * @param str	The error message
	 */
	public static void severe( String str )
	{
		Status status = new Status( IStatus.ERROR, TestCorePlugin.getPluginId(),
					IStatus.ERROR, str, null );//$NON-NLS-1$
		TestCorePlugin.getDefault().getLog().log( status );
	}
	
	/**
	 * Log a severe error
	 * 
	 * @param str	The error message
	 * @param t		The exceptions that cuased the error
	 */
	public static void severe( String str, Throwable t )
	{
		Status status = new Status( IStatus.ERROR, TestCorePlugin.getPluginId(),
					IStatus.ERROR, str, t );//$NON-NLS-1$
		TestCorePlugin.getDefault().getLog().log( status );
	}

	/**
	 * Log a severe error
	 * 
	 * @param message	The message to write to the log file
	 * @param c			The class making the loging request
	 * @param t			A throwable exception
	 */
	public static void severe( String message, Class c, Throwable t ) {
        String str = c.getName() + ":" + message; //$NON-NLS-1$
		Status status = new Status( IStatus.ERROR, TestCorePlugin.getPluginId(),
				IStatus.ERROR, str, t );//$NON-NLS-1$
		TestCorePlugin.getDefault().getLog().log( status );
    }

	/**
	 * Log a warning
	 * 
	 * @param str	The warning message
	 */
	public static void warning( String str )
	{
		Status status = new Status( IStatus.WARNING, TestCorePlugin.getPluginId(),
					IStatus.WARNING, str, null );//$NON-NLS-1$
		TestCorePlugin.getDefault().getLog().log( status );
	}

	/**
	 * Log a warning
	 * 
	 * @param message	The message to write to the log file
	 * @param c			The class making the loging request
	 * @param t			A throwable exception
	 */
	public static void warning( String message, Class c, Throwable t ) {
        String str = c.getName() + ":" + message; //$NON-NLS-1$
		Status status = new Status( IStatus.ERROR, TestCorePlugin.getPluginId(),
				IStatus.WARNING, str, t );//$NON-NLS-1$
		TestCorePlugin.getDefault().getLog().log( status );
    }
	
	/**
	 * Write an informational message to the log
	 * 
	 * @param str	The message to write to the log file
	 */
	public static void info( String str )
	{
		Status status = new Status( IStatus.INFO, TestCorePlugin.getPluginId(),
					IStatus.INFO, str, null );//$NON-NLS-1$
		TestCorePlugin.getDefault().getLog().log( status );
	}

	/**
	 * Write an informational message to the log
	 * 
	 * @param message	The message to write to the log file
	 * @param c			The class making the loging request
	 * @param t			A throwable exception
	 */
	public static void info( String message, Class c, Throwable t ) {
        String str = c.getName() + ":" + message; //$NON-NLS-1$
		Status status = new Status( IStatus.ERROR, TestCorePlugin.getPluginId(),
				IStatus.INFO, str, t );//$NON-NLS-1$
		TestCorePlugin.getDefault().getLog().log( status );
    }

}
