/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AbstractRecorderExecOptionsProvider.java,v 1.3 2008/03/13 15:32:12 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.framework;

import java.io.File;

import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.execution.recorder.RecorderFactory;

/**
 * Abstract extension of an IRecorderExecOptionsProvider. The following methods must
 * be extended by using classes.
 * <p/>
 * 	public String getVMArgs();
 * <p/>	
 *	public String getClasspathEntries();
 * <p/>	
 *	public File[] getRecorderJars();
 * <p/>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Jeffery Nevicosi
 * @version March 13, 2008
 * @since   February 1, 2006
 */
public abstract class AbstractRecorderExecOptionsProvider implements
		IRecorderExecOptionsProvider {


	protected Recorder recorder;
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderClientHelper#getRecorder()
	 */
	public Recorder getRecorder() {
		return recorder;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider#getRecorderID()
	 */
	public String getRecorderID() {
		return recorder.getId();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider#setRecorderID(java.lang.String)
	 */
	public void setRecorder(String id) {
		recorder = RecorderFactory.getInstance().getRecorderWithID(id);		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderProvider#setRecorder(org.eclipse.hyades.execution.recorder.Recorder)
	 */
	public void setRecorder(Recorder recorder) {
		this.recorder = recorder;		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderExecOptionsProvider#getClasspathEntries()
	 */
	public String getExtraClasspathEntries() {
		return "";
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderExecOptionsProvider#getVMArgs()
	 */
	public String getVMArgs() {
		String debugPort = System.getProperty("debugPort");	//$NON-NLS-1$	
		String debugParam="";//$NON-NLS-1$
		if(debugPort!=null)
		{
				debugParam+="-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address="+debugPort;//$NON-NLS-1$
		}
		return debugParam;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.test.provisional.recorder.framework.IRecorderExecOptionsProvider#getRecorderJars()
	 */
	public File[] getRecorderJars() {
		return new File[0];
	}
	
	
}
