/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IRecorderClientHelper.java,v 1.4 2008/11/25 18:31:34 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.test.provisional.recorder.framework;

import org.eclipse.hyades.execution.recorder.local.appadapters.IRecorderApplicationAdapter;
import org.eclipse.hyades.internal.execution.recorder.local.RecorderClient;

/**
 * <p>Interface for the recorder provider, {@link IRecorderClientHelper}.
 * The {@link RecorderClient} (internal class which handles initializing and 
 * launching recorders) will call these methods at intervals during setup.</p>
 *  
 * <p>It is highly advisable to extend (at least) the {@link #preSetup()} method.</p>
 * 
 * <p>Implementations are responsible for configuring the associated recorder 
 * application (see {@link IRecorderApplicationAdapter}) during initialization.  For example:</p>
 * 
 * <p><code>RecorderAppAdapterFactory.getInstance().getAppAdapter(&lt;recorder application ID&gt;).setInitString(&lt;initialization string&gt;);</code></p>
 * 
 * <p>The associated recorder application should be configured in the {@link #preSetup()} method.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Jeffery Nevicosi
 * @version November 25, 2008
 * @since   February 1, 2006
 */
public interface IRecorderClientHelper  extends IRecorderProvider {

	/**
	 * Called before any other calls, to verify that it is OK to proceed.
	 * @return true if it is ok to begin recorder launch
	 */
	public boolean okToLaunch();
	
	/**
	 * Called before any other initialization steps.  If using RecorderClientHelperAdapter
	 * MUST extend this method
	 * @return true if no errors and OK to proceed
	 */
	public boolean preSetup();
	
	/**
	 * Called immediately before recording is started.
	 * @return true if no errors and OK to proceed
	 */
	public boolean preStartRecording();
	
	/**
	 * Called after recording is started
	 * @return true if no errors and OK to proceed
	 */
	public boolean postStartRecording();
	
	/**
	 * Called immediately before recording is stopped.
	 * @return true if no errors and OK to proceed
	 */
	public boolean preStopRecording();
	
	/**
	 * Called after recording stops & finishes.  
	 * @return true if no errors and OK to proceed
	 */
	public boolean postStopRecording();
	
	/**
	 * Called after test generation completes.  Use this method for final recorder cleanup.
	 * @return true if no errors and OK to proceed.
	 */
	public boolean cleanup();
}
